/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.hubspot.horizon.HttpClient;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.HttpRuntimeException;
import com.hubspot.horizon.ning.NingAsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class NingHttpClient
implements HttpClient {
    private final NingAsyncHttpClient delegate;

    public NingHttpClient() {
        this(HttpConfig.newBuilder().build());
    }

    public NingHttpClient(HttpConfig config) {
        this.delegate = new NingAsyncHttpClient((HttpConfig)Preconditions.checkNotNull((Object)config));
    }

    public HttpResponse execute(HttpRequest request) throws HttpRuntimeException {
        return this.execute((HttpRequest)Preconditions.checkNotNull((Object)request), HttpRequest.Options.DEFAULT);
    }

    public HttpResponse execute(HttpRequest request, HttpRequest.Options options) throws HttpRuntimeException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)options);
        try {
            return (HttpResponse)this.delegate.execute(request, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpRuntimeException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), HttpRuntimeException.class);
            throw new HttpRuntimeException(e.getCause());
        }
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

