/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client;

import com.hubspot.horizon.shaded.com.ning.http.util.MiscUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Realm {
    private static final String NC = "00000001";
    private final String principal;
    private final String password;
    private final AuthScheme scheme;
    private final String realmName;
    private final String nonce;
    private final String algorithm;
    private final String response;
    private final String opaque;
    private final String qop;
    private final String nc;
    private final String cnonce;
    private final String uri;
    private final String methodName;
    private final boolean usePreemptiveAuth;
    private final String enc;
    private final String host;
    private final boolean messageType2Received;
    private final boolean useAbsoluteURI;
    private final boolean omitQuery;
    private final String domain;

    private Realm(AuthScheme scheme, String principal, String password, String realmName, String nonce, String algorithm, String response, String qop, String nc, String cnonce, String uri, String method, boolean usePreemptiveAuth, String domain, String enc, String host, boolean messageType2Received, String opaque, boolean useAbsoluteURI, boolean omitQuery) {
        this.principal = principal;
        this.password = password;
        this.scheme = scheme;
        this.realmName = realmName;
        this.nonce = nonce;
        this.algorithm = algorithm;
        this.response = response;
        this.opaque = opaque;
        this.qop = qop;
        this.nc = nc;
        this.cnonce = cnonce;
        this.uri = uri;
        this.methodName = method;
        this.usePreemptiveAuth = usePreemptiveAuth;
        this.domain = domain;
        this.enc = enc;
        this.host = host;
        this.messageType2Received = messageType2Received;
        this.useAbsoluteURI = useAbsoluteURI;
        this.omitQuery = omitQuery;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthScheme getAuthScheme() {
        return this.scheme;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getUri() {
        return this.uri;
    }

    public String getEncoding() {
        return this.enc;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean getUsePreemptiveAuth() {
        return this.usePreemptiveAuth;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getNtlmDomain() {
        return this.domain;
    }

    public String getNtlmHost() {
        return this.host;
    }

    public boolean isNtlmMessageType2Received() {
        return this.messageType2Received;
    }

    public boolean isUseAbsoluteURI() {
        return this.useAbsoluteURI;
    }

    public boolean isOmitQuery() {
        return this.omitQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Realm realm = (Realm)o;
        if (this.algorithm != null ? !this.algorithm.equals(realm.algorithm) : realm.algorithm != null) {
            return false;
        }
        if (this.cnonce != null ? !this.cnonce.equals(realm.cnonce) : realm.cnonce != null) {
            return false;
        }
        if (this.nc != null ? !this.nc.equals(realm.nc) : realm.nc != null) {
            return false;
        }
        if (this.nonce != null ? !this.nonce.equals(realm.nonce) : realm.nonce != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(realm.password) : realm.password != null) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(realm.principal) : realm.principal != null) {
            return false;
        }
        if (this.qop != null ? !this.qop.equals(realm.qop) : realm.qop != null) {
            return false;
        }
        if (this.realmName != null ? !this.realmName.equals(realm.realmName) : realm.realmName != null) {
            return false;
        }
        if (this.response != null ? !this.response.equals(realm.response) : realm.response != null) {
            return false;
        }
        if (this.scheme != realm.scheme) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(realm.uri) : realm.uri != null) {
            return false;
        }
        if (this.useAbsoluteURI != !realm.useAbsoluteURI) {
            return false;
        }
        return this.omitQuery == !realm.omitQuery;
    }

    public String toString() {
        return "Realm{principal='" + this.principal + '\'' + ", password='" + this.password + '\'' + ", scheme=" + (Object)((Object)this.scheme) + ", realmName='" + this.realmName + '\'' + ", nonce='" + this.nonce + '\'' + ", algorithm='" + this.algorithm + '\'' + ", response='" + this.response + '\'' + ", qop='" + this.qop + '\'' + ", nc='" + this.nc + '\'' + ", cnonce='" + this.cnonce + '\'' + ", uri='" + this.uri + '\'' + ", methodName='" + this.methodName + '\'' + ", useAbsoluteURI='" + this.useAbsoluteURI + '\'' + ", omitQuery='" + this.omitQuery + '\'' + '}';
    }

    public int hashCode() {
        int result = this.principal != null ? this.principal.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.realmName != null ? this.realmName.hashCode() : 0);
        result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
        result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.qop != null ? this.qop.hashCode() : 0);
        result = 31 * result + (this.nc != null ? this.nc.hashCode() : 0);
        result = 31 * result + (this.cnonce != null ? this.cnonce.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public static class RealmBuilder {
        private String principal = "";
        private String password = "";
        private AuthScheme scheme = AuthScheme.NONE;
        private String realmName = "";
        private String nonce = "";
        private String algorithm = "MD5";
        private String response = "";
        private String opaque = "";
        private String qop = "auth";
        private String nc = "00000001";
        private String cnonce = "";
        private String uri = "";
        private String methodName = "GET";
        private boolean usePreemptive = false;
        private String domain = System.getProperty("http.auth.ntlm.domain", "");
        private String enc = "UTF-8";
        private String host = "localhost";
        private boolean messageType2Received = false;
        private boolean useAbsoluteURI = true;
        private boolean omitQuery = false;

        @Deprecated
        public String getDomain() {
            return this.domain;
        }

        @Deprecated
        public RealmBuilder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public String getNtlmDomain() {
            return this.domain;
        }

        public RealmBuilder setNtlmDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public String getNtlmHost() {
            return this.host;
        }

        public RealmBuilder setNtlmHost(String host) {
            this.host = host;
            return this;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public RealmBuilder setPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public RealmBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public AuthScheme getScheme() {
            return this.scheme;
        }

        public RealmBuilder setScheme(AuthScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public RealmBuilder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public String getNonce() {
            return this.nonce;
        }

        public RealmBuilder setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public RealmBuilder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public String getResponse() {
            return this.response;
        }

        public RealmBuilder setResponse(String response) {
            this.response = response;
            return this;
        }

        public String getOpaque() {
            return this.opaque;
        }

        public RealmBuilder setOpaque(String opaque) {
            this.opaque = opaque;
            return this;
        }

        public String getQop() {
            return this.qop;
        }

        public RealmBuilder setQop(String qop) {
            this.qop = qop;
            return this;
        }

        public String getNc() {
            return this.nc;
        }

        public RealmBuilder setNc(String nc) {
            this.nc = nc;
            return this;
        }

        public String getUri() {
            return this.uri;
        }

        public RealmBuilder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public RealmBuilder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public boolean getUsePreemptiveAuth() {
            return this.usePreemptive;
        }

        public RealmBuilder setUsePreemptiveAuth(boolean usePreemptiveAuth) {
            this.usePreemptive = usePreemptiveAuth;
            return this;
        }

        public boolean isUseAbsoluteURI() {
            return this.useAbsoluteURI;
        }

        public RealmBuilder setUseAbsoluteURI(boolean useAbsoluteURI) {
            this.useAbsoluteURI = useAbsoluteURI;
            return this;
        }

        public boolean isOmitQuery() {
            return this.omitQuery;
        }

        public RealmBuilder setOmitQuery(boolean omitQuery) {
            this.omitQuery = omitQuery;
            return this;
        }

        public RealmBuilder parseWWWAuthenticateHeader(String headerLine) {
            this.setRealmName(this.match(headerLine, "realm"));
            this.setNonce(this.match(headerLine, "nonce"));
            String algorithm = this.match(headerLine, "algorithm");
            if (MiscUtil.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            this.setOpaque(this.match(headerLine, "opaque"));
            this.setQop(this.match(headerLine, "qop"));
            if (MiscUtil.isNonEmpty(this.getNonce())) {
                this.setScheme(AuthScheme.DIGEST);
            } else {
                this.setScheme(AuthScheme.BASIC);
            }
            return this;
        }

        public RealmBuilder setNtlmMessageType2Received(boolean messageType2Received) {
            this.messageType2Received = messageType2Received;
            return this;
        }

        public RealmBuilder clone(Realm clone) {
            this.setRealmName(clone.getRealmName());
            this.setAlgorithm(clone.getAlgorithm());
            this.setMethodName(clone.getMethodName());
            this.setNc(clone.getNc());
            this.setNonce(clone.getNonce());
            this.setPassword(clone.getPassword());
            this.setPrincipal(clone.getPrincipal());
            this.setEnconding(clone.getEncoding());
            this.setOpaque(clone.getOpaque());
            this.setQop(clone.getQop());
            this.setScheme(clone.getScheme());
            this.setUri(clone.getUri());
            this.setUsePreemptiveAuth(clone.getUsePreemptiveAuth());
            this.setNtlmDomain(clone.getNtlmDomain());
            this.setNtlmHost(clone.getNtlmHost());
            this.setNtlmMessageType2Received(clone.isNtlmMessageType2Received());
            this.setUseAbsoluteURI(clone.isUseAbsoluteURI());
            this.setOmitQuery(clone.isOmitQuery());
            return this;
        }

        private void newCnonce() {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] b = md.digest(String.valueOf(System.currentTimeMillis()).getBytes("ISO-8859-1"));
                this.cnonce = RealmBuilder.toHexString(b);
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }

        private String match(String headerLine, String token) {
            if (headerLine == null) {
                return "";
            }
            int match = headerLine.indexOf(token);
            if (match <= 0) {
                return "";
            }
            int traillingComa = headerLine.indexOf(",", match += token.length() + 1);
            String value = headerLine.substring(match, traillingComa > 0 ? traillingComa : headerLine.length());
            value = value.endsWith("\"") ? value.substring(0, value.length() - 1) : value;
            return value.startsWith("\"") ? value.substring(1) : value;
        }

        public String getEncoding() {
            return this.enc;
        }

        public RealmBuilder setEnconding(String enc) {
            this.enc = enc;
            return this;
        }

        private void newResponse() throws UnsupportedEncodingException {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException(e);
            }
            md.update((this.principal + ":" + this.realmName + ":" + this.password).getBytes("ISO-8859-1"));
            byte[] ha1 = md.digest();
            md.reset();
            md.update((this.methodName + ':' + this.uri).getBytes("ISO-8859-1"));
            byte[] ha2 = md.digest();
            if (this.qop == null || this.qop.equals("")) {
                md.update((RealmBuilder.toBase16(ha1) + ':' + this.nonce + ':' + RealmBuilder.toBase16(ha2)).getBytes("ISO-8859-1"));
            } else {
                md.update((RealmBuilder.toBase16(ha1) + ':' + this.nonce + ':' + Realm.NC + ':' + this.cnonce + ':' + this.qop + ':' + RealmBuilder.toBase16(ha2)).getBytes("ISO-8859-1"));
            }
            byte[] digest = md.digest();
            this.response = RealmBuilder.toHexString(digest);
        }

        private static String toHexString(byte[] data) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < data.length; ++i) {
                buffer.append(Integer.toHexString((data[i] & 0xF0) >>> 4));
                buffer.append(Integer.toHexString(data[i] & 0xF));
            }
            return buffer.toString();
        }

        private static String toBase16(byte[] bytes) {
            int base = 16;
            StringBuilder buf = new StringBuilder();
            for (byte b : bytes) {
                int bi = 0xFF & b;
                int c = 48 + bi / base % base;
                if (c > 57) {
                    c = 97 + (c - 48 - 10);
                }
                buf.append((char)c);
                c = 48 + bi % base;
                if (c > 57) {
                    c = 97 + (c - 48 - 10);
                }
                buf.append((char)c);
            }
            return buf.toString();
        }

        public Realm build() {
            if (MiscUtil.isNonEmpty(this.nonce)) {
                this.newCnonce();
                try {
                    this.newResponse();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Realm(this.scheme, this.principal, this.password, this.realmName, this.nonce, this.algorithm, this.response, this.qop, this.nc, this.cnonce, this.uri, this.methodName, this.usePreemptive, this.domain, this.enc, this.host, this.messageType2Received, this.opaque, this.useAbsoluteURI, this.omitQuery);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthScheme {
        DIGEST,
        BASIC,
        NTLM,
        SPNEGO,
        KERBEROS,
        NONE;

    }
}

