/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.apache;

import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;

public class ApacheResponseBodyPart
extends HttpResponseBodyPart {
    private final byte[] chunk;
    private final boolean isLast;
    private boolean closeConnection;

    public ApacheResponseBodyPart(URI uri, byte[] chunk, AsyncHttpProvider provider, boolean last) {
        super(uri, provider);
        this.chunk = chunk;
        this.isLast = last;
    }

    public byte[] getBodyPartBytes() {
        return this.chunk;
    }

    public int writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.chunk);
        return this.chunk.length;
    }

    public ByteBuffer getBodyByteBuffer() {
        return ByteBuffer.wrap(this.chunk);
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void markUnderlyingConnectionAsClosed() {
        this.closeConnection = true;
    }

    public boolean closeUnderlyingConnection() {
        return this.closeConnection;
    }

    public int length() {
        return this.chunk != null ? this.chunk.length : 0;
    }
}

