/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty;

import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpProviderConfig;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProviderConfig
implements AsyncHttpProviderConfig<String, Object> {
    public static final String USE_BLOCKING_IO = "useBlockingIO";
    public static final String USE_DIRECT_BYTEBUFFER = "bufferFactory";
    public static final String EXECUTE_ASYNC_CONNECT = "asyncConnect";
    public static final String DISABLE_NESTED_REQUEST = "disableNestedRequest";
    public static final String BOSS_EXECUTOR_SERVICE = "bossExecutorService";
    public static final String REUSE_ADDRESS = "reuseAddress";
    public static final String HTTP_CLIENT_CODEC_MAX_INITIAL_LINE_LENGTH = "httpClientCodecMaxInitialLineLength";
    public static final String HTTP_CLIENT_CODEC_MAX_HEADER_SIZE = "httpClientCodecMaxHeaderSize";
    public static final String HTTP_CLIENT_CODEC_MAX_CHUNK_SIZE = "httpClientCodecMaxChunkSize";
    public static final String HTTPS_CLIENT_CODEC_MAX_INITIAL_LINE_LENGTH = "httpsClientCodecMaxInitialLineLength";
    public static final String HTTPS_CLIENT_CODEC_MAX_HEADER_SIZE = "httpsClientCodecMaxHeaderSize";
    public static final String HTTPS_CLIENT_CODEC_MAX_CHUNK_SIZE = "httpsClientCodecMaxChunkSize";
    public static final String SOCKET_CHANNEL_FACTORY = "socketChannelFactory";
    private final ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private boolean disableZeroCopy;
    private Timer nettyTimer;
    private long handshakeTimeoutInMillis = 10000L;

    public NettyAsyncHttpProviderConfig() {
        this.properties.put(REUSE_ADDRESS, "false");
    }

    public NettyAsyncHttpProviderConfig addProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public <T> T getProperty(String name, Class<T> type, T defaultValue) {
        Object value = this.properties.get(name);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        return defaultValue;
    }

    @Override
    public Object removeProperty(String name) {
        return this.properties.remove(name);
    }

    @Override
    public Set<Map.Entry<String, Object>> propertiesSet() {
        return this.properties.entrySet();
    }

    public void setDisableZeroCopy(boolean disableZeroCopy) {
        this.disableZeroCopy = disableZeroCopy;
    }

    public boolean isDisableZeroCopy() {
        return this.disableZeroCopy;
    }

    public Timer getNettyTimer() {
        return this.nettyTimer;
    }

    public void setNettyTimer(Timer nettyTimer) {
        this.nettyTimer = nettyTimer;
    }

    public long getHandshakeTimeoutInMillis() {
        return this.handshakeTimeoutInMillis;
    }

    public void setHandshakeTimeoutInMillis(long handshakeTimeoutInMillis) {
        this.handshakeTimeoutInMillis = handshakeTimeoutInMillis;
    }
}

