/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty;

import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseHeaders;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import java.net.URI;
import java.util.Map;

public class ResponseHeaders
extends HttpResponseHeaders {
    private final HttpChunkTrailer trailingHeaders;
    private final HttpResponse response;
    private final FluentCaseInsensitiveStringsMap headers;

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider) {
        super(uri, provider, false);
        this.trailingHeaders = null;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    public ResponseHeaders(URI uri, HttpResponse response, AsyncHttpProvider provider, HttpChunkTrailer traillingHeaders) {
        super(uri, provider, true);
        this.trailingHeaders = traillingHeaders;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    private FluentCaseInsensitiveStringsMap computerHeaders() {
        FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry<String, String> header : this.response.getHeaders()) {
            h.add(header.getKey(), header.getValue());
        }
        if (this.trailingHeaders != null) {
            for (Map.Entry<String, String> header : this.trailingHeaders.getHeaders()) {
                h.add(header.getKey(), header.getValue());
            }
        }
        return h;
    }

    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers;
    }
}

