/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout;

import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.NettyResponseFuture;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout.TimeoutTimerTask;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.hubspot.horizon.shaded.com.ning.http.util.DateUtil;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdleConnectionTimeoutTimerTask
extends TimeoutTimerTask {
    private final long idleConnectionTimeout;
    private final long requestTimeoutInstant;

    public IdleConnectionTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder, long requestTimeout, long idleConnectionTimeout) {
        super(nettyResponseFuture, provider, timeoutsHolder);
        this.idleConnectionTimeout = idleConnectionTimeout;
        this.requestTimeoutInstant = requestTimeout >= 0L ? nettyResponseFuture.getStart() + requestTimeout : Long.MAX_VALUE;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (this.provider.isClose()) {
            this.timeoutsHolder.cancel();
            return;
        }
        if (!this.nettyResponseFuture.isDone() && !this.nettyResponseFuture.isCancelled()) {
            long now = DateUtil.millisTime();
            long currentIdleConnectionTimeoutInstant = this.idleConnectionTimeout + this.nettyResponseFuture.getLastTouch();
            long durationBeforeCurrentIdleConnectionTimeout = currentIdleConnectionTimeoutInstant - now;
            if (durationBeforeCurrentIdleConnectionTimeout <= 0L) {
                String message = "Idle connection timeout to " + this.nettyResponseFuture.getChannelRemoteAddress() + " of " + this.idleConnectionTimeout + " ms";
                long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
                this.expire(message, durationSinceLastTouch);
                this.nettyResponseFuture.setIdleConnectionTimeoutReached();
            } else {
                this.timeoutsHolder.idleConnectionTimeout = currentIdleConnectionTimeoutInstant < this.requestTimeoutInstant ? this.provider.newTimeoutInMs(this, durationBeforeCurrentIdleConnectionTimeout) : null;
            }
        } else {
            this.timeoutsHolder.cancel();
        }
    }
}

