/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout;

import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.NettyResponseFuture;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout.TimeoutTimerTask;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.hubspot.horizon.shaded.com.ning.http.util.DateUtil;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder) {
        super(nettyResponseFuture, provider, timeoutsHolder);
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        this.timeoutsHolder.cancel();
        if (this.provider.isClose()) {
            return;
        }
        if (!this.nettyResponseFuture.isDone() && !this.nettyResponseFuture.isCancelled()) {
            String message = "Request timed out to " + this.nettyResponseFuture.getChannelRemoteAddress() + " of " + this.nettyResponseFuture.getRequestTimeoutInMs() + " ms";
            long age = DateUtil.millisTime() - this.nettyResponseFuture.getStart();
            this.expire(message, age);
            this.nettyResponseFuture.setRequestTimeoutReached();
        }
    }
}

