/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.multipart;

import java.io.UnsupportedEncodingException;

public class MultipartEncodingUtil {
    public static byte[] getAsciiBytes(String data) {
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAsciiString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        try {
            return new String(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(String data, String charset) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Unsupported encoding: %s", charset));
        }
    }
}

