/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.multipart;

import com.hubspot.horizon.shaded.com.ning.http.multipart.MultipartEncodingUtil;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Part
implements com.hubspot.horizon.shaded.com.ning.http.client.Part {
    private static final Logger LOGGER = LoggerFactory.getLogger(Part.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = MultipartEncodingUtil.getAsciiBytes("\r\n");
    public static final String QUOTE = "\"";
    public static final byte[] QUOTE_BYTES = MultipartEncodingUtil.getAsciiBytes("\"");
    public static final String EXTRA = "--";
    public static final byte[] EXTRA_BYTES = MultipartEncodingUtil.getAsciiBytes("--");
    public static final String CONTENT_DISPOSITION = "Content-Disposition: ";
    public static final byte[] CONTENT_DISPOSITION_BYTES = MultipartEncodingUtil.getAsciiBytes("Content-Disposition: ");
    public static final String FORM_DATA_DISPOSITION_TYPE = "form-data";
    public static final byte[] FORM_DATA_DISPOSITION_TYPE_BYTES = MultipartEncodingUtil.getAsciiBytes("form-data");
    public static final String NAME = "; name=";
    public static final byte[] NAME_BYTES = MultipartEncodingUtil.getAsciiBytes("; name=");
    public static final String CONTENT_TYPE = "Content-Type: ";
    public static final byte[] CONTENT_TYPE_BYTES = MultipartEncodingUtil.getAsciiBytes("Content-Type: ");
    public static final String CHARSET = "; charset=";
    public static final byte[] CHARSET_BYTES = MultipartEncodingUtil.getAsciiBytes("; charset=");
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    public static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = MultipartEncodingUtil.getAsciiBytes("Content-Transfer-Encoding: ");
    public static final String CONTENT_ID = "Content-ID: ";
    public static final byte[] CONTENT_ID_BYTES = MultipartEncodingUtil.getAsciiBytes("Content-ID: ");
    private String dispositionType;

    public abstract String getName();

    public abstract String getContentType();

    public abstract String getCharSet();

    public abstract String getTransferEncoding();

    public abstract String getContentId();

    public String getDispositionType() {
        return this.dispositionType;
    }

    public void setDispositionType(String dispositionType) {
        this.dispositionType = dispositionType;
    }

    protected void sendStart(OutputStream out, byte[] boundary) throws IOException {
        out.write(EXTRA_BYTES);
        out.write(boundary);
    }

    private int startLength(byte[] boundary) {
        return EXTRA_BYTES.length + boundary.length;
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        out.write(CRLF_BYTES);
        out.write(CONTENT_DISPOSITION_BYTES);
        if (this.dispositionType != null) {
            out.write(MultipartEncodingUtil.getAsciiBytes(this.dispositionType));
        } else {
            out.write(FORM_DATA_DISPOSITION_TYPE_BYTES);
        }
        if (this.getName() != null) {
            out.write(NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(this.getName()));
            out.write(QUOTE_BYTES);
        }
    }

    protected long dispositionHeaderLength() {
        long length = 0L;
        length += (long)CRLF_BYTES.length;
        length += (long)CONTENT_DISPOSITION_BYTES.length;
        length = this.dispositionType != null ? (length += (long)MultipartEncodingUtil.getAsciiBytes(this.dispositionType).length) : (length += (long)FORM_DATA_DISPOSITION_TYPE_BYTES.length);
        if (this.getName() != null) {
            length += (long)NAME_BYTES.length;
            length += (long)QUOTE_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(this.getName()).length;
            length += (long)QUOTE_BYTES.length;
        }
        return length;
    }

    protected void sendContentTypeHeader(OutputStream out) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TYPE_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(contentType));
            String charSet = this.getCharSet();
            if (charSet != null) {
                out.write(CHARSET_BYTES);
                out.write(MultipartEncodingUtil.getAsciiBytes(charSet));
            }
        }
    }

    protected long contentTypeHeaderLength() {
        long length = 0L;
        String contentType = this.getContentType();
        if (contentType != null) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_TYPE_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(contentType).length;
            String charSet = this.getCharSet();
            if (charSet != null) {
                length += (long)CHARSET_BYTES.length;
                length += (long)MultipartEncodingUtil.getAsciiBytes(charSet).length;
            }
        }
        return length;
    }

    protected void sendTransferEncodingHeader(OutputStream out) throws IOException {
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TRANSFER_ENCODING_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(transferEncoding));
        }
    }

    protected long transferEncodingHeaderLength() {
        long length = 0L;
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_TRANSFER_ENCODING_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(transferEncoding).length;
        }
        return length;
    }

    protected void sendContentIdHeader(OutputStream out) throws IOException {
        String contentId = this.getContentId();
        if (contentId != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_ID_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(contentId));
        }
    }

    protected long contentIdHeaderLength() {
        long length = 0L;
        String contentId = this.getContentId();
        if (contentId != null) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_ID_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(contentId).length;
        }
        return length;
    }

    protected void sendEndOfHeader(OutputStream out) throws IOException {
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    protected long endOfHeaderLength() {
        return CRLF_BYTES.length * 2;
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected abstract long lengthOfData();

    protected void sendEnd(OutputStream out) throws IOException {
        out.write(CRLF_BYTES);
    }

    protected long endLength() {
        return CRLF_BYTES.length;
    }

    public void send(OutputStream out, byte[] boundary) throws IOException {
        this.sendStart(out, boundary);
        this.sendDispositionHeader(out);
        this.sendContentTypeHeader(out);
        this.sendTransferEncodingHeader(out);
        this.sendContentIdHeader(out);
        this.sendEndOfHeader(out);
        this.sendData(out);
        this.sendEnd(out);
    }

    public long length(byte[] boundary) {
        long lengthOfData = this.lengthOfData();
        if (lengthOfData < 0L) {
            return -1L;
        }
        return lengthOfData + (long)this.startLength(boundary) + this.dispositionHeaderLength() + this.contentTypeHeaderLength() + this.transferEncodingHeaderLength() + this.contentIdHeaderLength() + this.endOfHeaderLength() + this.endLength();
    }

    public String toString() {
        return "name=" + this.getName() + " contentType=" + this.getContentType() + " charset=" + this.getCharSet() + " tranferEncoding=" + this.getTransferEncoding() + " contentId=" + this.getContentId() + " dispositionType=" + this.getDispositionType();
    }

    public static void sendParts(OutputStream out, Part[] parts, byte[] partBoundary) throws IOException {
        if (parts == null) {
            throw new NullPointerException("partsl");
        }
        if (partBoundary == null || partBoundary.length == 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        for (Part part : parts) {
            part.send(out, partBoundary);
        }
        out.write(EXTRA_BYTES);
        out.write(partBoundary);
        out.write(EXTRA_BYTES);
        out.write(CRLF_BYTES);
    }

    public static void sendMessageEnd(OutputStream out, byte[] partBoundary) throws IOException {
        if (partBoundary == null || partBoundary.length == 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        out.write(EXTRA_BYTES);
        out.write(partBoundary);
        out.write(EXTRA_BYTES);
        out.write(CRLF_BYTES);
    }

    public static void sendPart(OutputStream out, Part part, byte[] partBoundary) throws IOException {
        if (part == null) {
            throw new NullPointerException("parts");
        }
        part.send(out, partBoundary);
    }

    public static long getLengthOfParts(Part[] parts, byte[] partBoundary) {
        try {
            if (parts == null) {
                throw new NullPointerException("parts");
            }
            long total = 0L;
            for (Part part : parts) {
                long l = part.length(partBoundary);
                if (l < 0L) {
                    return -1L;
                }
                total += l;
            }
            total += (long)EXTRA_BYTES.length;
            total += (long)partBoundary.length;
            total += (long)EXTRA_BYTES.length;
            return total += (long)CRLF_BYTES.length;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }
}

