/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.org.jboss.netty.handler.traffic;

import com.hubspot.horizon.shaded.org.jboss.netty.channel.Channel;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelEvent;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelState;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelStateEvent;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.MessageEvent;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.SimpleChannelHandler;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.traffic.TrafficCounter;
import com.hubspot.horizon.shaded.org.jboss.netty.logging.InternalLogger;
import com.hubspot.horizon.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import com.hubspot.horizon.shaded.org.jboss.netty.util.DefaultObjectSizeEstimator;
import com.hubspot.horizon.shaded.org.jboss.netty.util.ExternalResourceReleasable;
import com.hubspot.horizon.shaded.org.jboss.netty.util.ObjectSizeEstimator;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timeout;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timer;
import com.hubspot.horizon.shaded.org.jboss.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private ObjectSizeEstimator objectSizeEstimator;
    protected Timer timer;
    private volatile Timeout timeout;
    private long writeLimit;
    private long readLimit;
    protected long checkInterval = 1000L;
    final AtomicBoolean release = new AtomicBoolean(false);

    private void init(ObjectSizeEstimator newObjectSizeEstimator, Timer newTimer, long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.objectSizeEstimator = newObjectSizeEstimator;
        this.timer = newTimer;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        this.init(new DefaultObjectSizeEstimator(), timer, writeLimit, readLimit, 1000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, 1000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, 1000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        this.init(objectSizeEstimator, timer, 0L, 0L, 1000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long checkInterval) {
        this.init(new DefaultObjectSizeEstimator(), timer, 0L, 0L, checkInterval);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        this.init(objectSizeEstimator, timer, 0L, 0L, checkInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    private static long getTimeToWait(long limit, long bytes, long lastTime, long curtime) {
        long interval = curtime - lastTime;
        if (interval <= 0L) {
            return 0L;
        }
        return (bytes * 1000L / limit - interval) / 10L * 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    long curtime = System.currentTimeMillis();
                                    long size = this.objectSizeEstimator.estimateSize(evt.getMessage());
                                    if (this.trafficCounter == null) break block9;
                                    this.trafficCounter.bytesRecvFlowControl(size);
                                    if (this.readLimit == 0L) {
                                        Object var12_5 = null;
                                        break block10;
                                    }
                                    long wait = AbstractTrafficShapingHandler.getTimeToWait(this.readLimit, this.trafficCounter.getCurrentReadBytes(), this.trafficCounter.getLastTime(), curtime);
                                    if (wait < 10L) break block9;
                                    Channel channel = ctx.getChannel();
                                    if (channel != null && channel.isConnected()) {
                                        if (this.timer == null) {
                                            if (this.release.get()) {
                                                break block11;
                                            }
                                            Thread.sleep(wait);
                                            break block12;
                                        }
                                        if (ctx.getAttachment() == null) {
                                            ctx.setAttachment(Boolean.TRUE);
                                            channel.setReadable(false);
                                            ReopenReadTimerTask timerTask = new ReopenReadTimerTask(ctx);
                                            this.timeout = this.timer.newTimeout(timerTask, wait, TimeUnit.MILLISECONDS);
                                            break block9;
                                        }
                                        if (this.release.get()) {
                                            break block13;
                                        }
                                        Thread.sleep(wait);
                                        break block9;
                                    }
                                    if (this.release.get()) {
                                        break block14;
                                    }
                                    Thread.sleep(wait);
                                    break block9;
                                }
                                catch (Throwable throwable) {
                                    Object var12_11 = null;
                                    super.messageReceived(ctx, evt);
                                    throw throwable;
                                }
                            }
                            super.messageReceived(ctx, evt);
                            return;
                        }
                        Object var12_6 = null;
                        super.messageReceived(ctx, evt);
                        return;
                    }
                    Object var12_7 = null;
                    super.messageReceived(ctx, evt);
                    return;
                }
                Object var12_8 = null;
                super.messageReceived(ctx, evt);
                return;
            }
            Object var12_9 = null;
            super.messageReceived(ctx, evt);
            return;
        }
        Object var12_10 = null;
        super.messageReceived(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        block4: {
            block6: {
                block5: {
                    try {
                        long curtime = System.currentTimeMillis();
                        long size = this.objectSizeEstimator.estimateSize(evt.getMessage());
                        if (this.trafficCounter == null) break block4;
                        this.trafficCounter.bytesWriteFlowControl(size);
                        if (this.writeLimit == 0L) {
                            Object var10_5 = null;
                            break block5;
                        }
                        long wait = AbstractTrafficShapingHandler.getTimeToWait(this.writeLimit, this.trafficCounter.getCurrentWrittenBytes(), this.trafficCounter.getLastTime(), curtime);
                        if (wait < 10L) break block4;
                        if (this.release.get()) {
                            break block6;
                        }
                        Thread.sleep(wait);
                        break block4;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        super.writeRequested(ctx, evt);
                        throw throwable;
                    }
                }
                super.writeRequested(ctx, evt);
                return;
            }
            Object var10_6 = null;
            super.writeRequested(ctx, evt);
            return;
        }
        Object var10_7 = null;
        super.writeRequested(ctx, evt);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        super.handleDownstream(ctx, e);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.timer.stop();
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    private class ReopenReadTimerTask
    implements TimerTask {
        final ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeoutArg) throws Exception {
            if (AbstractTrafficShapingHandler.this.release.get()) {
                return;
            }
            if (this.ctx != null && this.ctx.getChannel() != null && this.ctx.getChannel().isConnected()) {
                this.ctx.setAttachment(null);
                this.ctx.getChannel().setReadable(true);
            }
        }
    }
}

