/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.org.jboss.netty.util.internal;

import com.hubspot.horizon.shaded.org.jboss.netty.util.internal.SystemPropertyUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DetectionUtil {
    private static final int JAVA_VERSION = DetectionUtil.javaVersion0();
    private static final boolean HAS_UNSAFE = DetectionUtil.hasUnsafe(AtomicInteger.class.getClassLoader());
    private static final boolean IS_WINDOWS;

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    private static boolean hasUnsafe(ClassLoader loader) {
        boolean noUnsafe = SystemPropertyUtil.getBoolean("io.netty.noUnsafe", false);
        if (noUnsafe) {
            return false;
        }
        boolean tryUnsafe = SystemPropertyUtil.contains("io.netty.tryUnsafe") ? SystemPropertyUtil.getBoolean("io.netty.tryUnsafe", true) : SystemPropertyUtil.getBoolean("com.hubspot.horizon.shaded.org.jboss.netty.tryUnsafe", true);
        if (!tryUnsafe) {
            return false;
        }
        try {
            Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe", true, loader);
            return DetectionUtil.hasUnsafeField(unsafeClazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasUnsafeField(final Class<?> unsafeClass) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                unsafeClass.getDeclaredField("theUnsafe");
                return true;
            }
        });
    }

    private static int javaVersion0() {
        try {
            Class.forName("android.app.Application");
            return 6;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("java.util.concurrent.LinkedTransferQueue", false, BlockingQueue.class.getClassLoader());
                return 7;
            }
            catch (Exception e2) {
                try {
                    Class.forName("java.util.ArrayDeque", false, Queue.class.getClassLoader());
                    return 6;
                }
                catch (Exception exception) {
                    return 5;
                }
            }
        }
    }

    private DetectionUtil() {
    }

    static {
        String os = SystemPropertyUtil.get("os.name", "").toLowerCase();
        IS_WINDOWS = os.contains("win");
    }
}

