/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.jdk;

import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseHeaders;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseStatus;
import com.hubspot.horizon.shaded.com.ning.http.client.ResponseBase;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.Cookie;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.CookieDecoder;
import com.hubspot.horizon.shaded.com.ning.http.util.AsyncHttpProviderUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class JDKResponse
extends ResponseBase {
    private AtomicBoolean contentComputed = new AtomicBoolean(false);
    private String content;

    public JDKResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return AsyncHttpProviderUtils.contentToByte(this.bodyParts);
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.getResponseBodyAsBytes());
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        if (!this.contentComputed.get()) {
            this.content = AsyncHttpProviderUtils.contentToString(this.bodyParts, this.calculateCharset(charset));
        }
        return this.content;
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.contentComputed.get()) {
            return new ByteArrayInputStream(this.content.getBytes(this.calculateCharset(null)));
        }
        return AsyncHttpProviderUtils.contentToInputStream(this.bodyParts);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        if (!this.contentComputed.get()) {
            this.content = AsyncHttpProviderUtils.contentToString(this.bodyParts, this.calculateCharset(charset));
        }
        return this.content.length() <= maxLength ? this.content : this.content.substring(0, maxLength);
    }

    @Override
    protected List<Cookie> buildCookies() {
        ArrayList<Cookie> localCookies = new ArrayList<Cookie>();
        for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
            if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            List<String> v = header.getValue();
            for (String value : v) {
                localCookies.add(CookieDecoder.decode(value));
            }
        }
        return localCookies;
    }
}

