/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.util;

import com.hubspot.horizon.shaded.com.ning.http.util.StringCharSequence;

public final class UTF8UrlDecoder {
    private UTF8UrlDecoder() {
    }

    private static StringBuilder initSb(StringBuilder sb, String s, int i, int offset, int length) {
        if (sb != null) {
            return sb;
        }
        int initialSbLength = length > 500 ? length / 2 : length;
        return new StringBuilder(initialSbLength).append(s, offset, i);
    }

    private static int hexaDigit(char c) {
        return Character.digit(c, 16);
    }

    public static CharSequence decode(String s) {
        return UTF8UrlDecoder.decode(s, 0, s.length());
    }

    public static CharSequence decode(String s, int offset, int length) {
        StringBuilder sb = null;
        int i = offset;
        int end = length + offset;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '+') {
                sb = UTF8UrlDecoder.initSb(sb, s, i, offset, length);
                sb.append(' ');
                ++i;
                continue;
            }
            if (c == '%') {
                int y;
                if (end - i < 3) {
                    throw new IllegalArgumentException("UTF8UrlDecoder: Incomplete trailing escape (%) pattern");
                }
                int x = UTF8UrlDecoder.hexaDigit(s.charAt(i + 1));
                if (x == -1 || (y = UTF8UrlDecoder.hexaDigit(s.charAt(i + 2))) == -1) {
                    throw new IllegalArgumentException("UTF8UrlDecoder: Malformed");
                }
                sb = UTF8UrlDecoder.initSb(sb, s, i, offset, length);
                sb.append((char)(x * 16 + y));
                i += 3;
                continue;
            }
            if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        return sb != null ? sb.toString() : new StringCharSequence(s, offset, length);
    }
}

