/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.cookie;

public class Cookie {
    private final String name;
    private final String value;
    private final boolean wrap;
    private final String domain;
    private final String path;
    private final long maxAge;
    private final boolean secure;
    private final boolean httpOnly;

    @Deprecated
    public static Cookie newValidCookie(String name, String value, boolean wrap, String domain, String path, int expires, long maxAge, boolean secure, boolean httpOnly) {
        return Cookie.newValidCookie(name, value, wrap, domain, path, maxAge, secure, httpOnly);
    }

    public static Cookie newValidCookie(String name, String value, boolean wrap, String domain, String path, long maxAge, boolean secure, boolean httpOnly) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,; \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
        if (name.charAt(0) == '$') {
            throw new IllegalArgumentException("name starting with '$' not allowed: " + name);
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        domain = Cookie.validateValue("domain", domain);
        path = Cookie.validateValue("path", path);
        return new Cookie(name, value, wrap, domain, path, maxAge, secure, httpOnly);
    }

    private static String validateValue(String name, String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ';': {
                    throw new IllegalArgumentException(name + " contains one of the following prohibited characters: " + ";\\r\\n\\f\\v (" + value + ')');
                }
            }
        }
        return value;
    }

    public Cookie(String name, String value, boolean wrap, String domain, String path, long maxAge, boolean secure, boolean httpOnly) {
        this.name = name;
        this.value = value;
        this.wrap = wrap;
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public String getPath() {
        return this.path;
    }

    @Deprecated
    public long getExpires() {
        return Long.MIN_VALUE;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append('=');
        if (this.wrap) {
            buf.append('\"').append(this.value).append('\"');
        } else {
            buf.append(this.value);
        }
        if (this.domain != null) {
            buf.append("; domain=");
            buf.append(this.domain);
        }
        if (this.path != null) {
            buf.append("; path=");
            buf.append(this.path);
        }
        if (this.maxAge >= 0L) {
            buf.append("; maxAge=");
            buf.append(this.maxAge);
            buf.append('s');
        }
        if (this.secure) {
            buf.append("; secure");
        }
        if (this.httpOnly) {
            buf.append("; HTTPOnly");
        }
        return buf.toString();
    }
}

