/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http;

import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.hubspot.horizon.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.Channel;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpChunk;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpCodecUtil;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import com.hubspot.horizon.shaded.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import com.hubspot.horizon.shaded.org.jboss.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class HttpMessageEncoder
extends OneToOneEncoder {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final ChannelBuffer LAST_CHUNK = ChannelBuffers.copiedBuffer("0\r\n\r\n", CharsetUtil.US_ASCII);
    private volatile boolean transferEncodingChunked;

    protected HttpMessageEncoder() {
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof HttpMessage) {
            boolean contentMustBeEmpty;
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                if (HttpCodecUtil.isContentLengthSet(m)) {
                    contentMustBeEmpty = false;
                    this.transferEncodingChunked = false;
                    HttpCodecUtil.removeTransferEncodingChunked(m);
                } else {
                    if (!HttpCodecUtil.isTransferEncodingChunked(m)) {
                        m.headers().add("Transfer-Encoding", "chunked");
                    }
                    contentMustBeEmpty = true;
                    this.transferEncodingChunked = true;
                }
            } else {
                this.transferEncodingChunked = contentMustBeEmpty = HttpCodecUtil.isTransferEncodingChunked(m);
            }
            ChannelBuffer header = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
            this.encodeInitialLine(header, m);
            HttpMessageEncoder.encodeHeaders(header, m);
            header.writeByte(13);
            header.writeByte(10);
            ChannelBuffer content = m.getContent();
            if (!content.readable()) {
                return header;
            }
            if (contentMustBeEmpty) {
                throw new IllegalArgumentException("HttpMessage.content must be empty if Transfer-Encoding is chunked.");
            }
            return ChannelBuffers.wrappedBuffer(header, content);
        }
        if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (this.transferEncodingChunked) {
                if (chunk.isLast()) {
                    this.transferEncodingChunked = false;
                    if (chunk instanceof HttpChunkTrailer) {
                        ChannelBuffer trailer = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
                        trailer.writeByte(48);
                        trailer.writeByte(13);
                        trailer.writeByte(10);
                        HttpMessageEncoder.encodeTrailingHeaders(trailer, (HttpChunkTrailer)chunk);
                        trailer.writeByte(13);
                        trailer.writeByte(10);
                        return trailer;
                    }
                    return LAST_CHUNK.duplicate();
                }
                ChannelBuffer content = chunk.getContent();
                int contentLength = content.readableBytes();
                return ChannelBuffers.wrappedBuffer(ChannelBuffers.copiedBuffer(Integer.toHexString(contentLength), CharsetUtil.US_ASCII), ChannelBuffers.wrappedBuffer(CRLF), content.slice(content.readerIndex(), contentLength), ChannelBuffers.wrappedBuffer(CRLF));
            }
            return chunk.getContent();
        }
        return msg;
    }

    private static void encodeHeaders(ChannelBuffer buf, HttpMessage message) {
        try {
            for (Map.Entry h : message.headers()) {
                HttpMessageEncoder.encodeHeader(buf, (String)h.getKey(), (String)h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private static void encodeTrailingHeaders(ChannelBuffer buf, HttpChunkTrailer trailer) {
        try {
            for (Map.Entry h : trailer.trailingHeaders()) {
                HttpMessageEncoder.encodeHeader(buf, (String)h.getKey(), (String)h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private static void encodeHeader(ChannelBuffer buf, String header, String value) throws UnsupportedEncodingException {
        HttpMessageEncoder.encodeAscii(header, buf);
        buf.writeByte(58);
        buf.writeByte(32);
        HttpMessageEncoder.encodeAscii(value, buf);
        buf.writeByte(13);
        buf.writeByte(10);
    }

    protected static void encodeAscii(String s, ChannelBuffer buf) {
        for (int i = 0; i < s.length(); ++i) {
            buf.writeByte(HttpMessageEncoder.c2b(s.charAt(i)));
        }
    }

    private static byte c2b(char c) {
        if (c > '\u00ff') {
            return 63;
        }
        return (byte)c;
    }

    protected abstract void encodeInitialLine(ChannelBuffer var1, HttpMessage var2) throws Exception;
}

