/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.Preconditions;
import com.hubspot.smtp.client.Extension;
import com.hubspot.smtp.client.SendInterceptor;
import com.hubspot.smtp.client.SmtpSessionConfig;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(typeImmutable="*", visibility=Value.Style.ImplementationVisibility.PUBLIC)
abstract class AbstractSmtpSessionConfig {
    AbstractSmtpSessionConfig() {
    }

    public abstract InetSocketAddress getRemoteAddress();

    public abstract Optional<InetSocketAddress> getLocalAddress();

    public abstract Optional<Duration> getKeepAliveTimeout();

    public abstract Optional<Duration> getReadTimeout();

    @Deprecated
    public abstract Optional<Duration> getInitialResponseReadTimeout();

    @Value.Default
    public Duration getInitialResponseTimeout() {
        return this.getInitialResponseReadTimeout().orElse(Duration.ofMinutes(1L));
    }

    public abstract Optional<SendInterceptor> getSendInterceptor();

    public abstract Optional<Consumer<Throwable>> getExceptionHandler();

    @Deprecated
    @Value.Default
    public Duration getConnectionTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Value.Default
    public EnumSet<Extension> getDisabledExtensions() {
        return EnumSet.noneOf(Extension.class);
    }

    @Value.Default
    public String getConnectionId() {
        return "unidentified-connection";
    }

    @Value.Default
    public ChannelHandler[] getAddFirstCustomHandlers() {
        return new ChannelHandler[0];
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((!this.getKeepAliveTimeout().orElse(Duration.ofSeconds(1L)).isZero() ? 1 : 0) != 0, (Object)"keepAliveTimeout must not be zero; use Optional.empty() to disable keepalive");
    }

    public static SmtpSessionConfig forRemoteAddress(String host, int port) {
        return AbstractSmtpSessionConfig.forRemoteAddress(InetSocketAddress.createUnresolved(host, port));
    }

    public static SmtpSessionConfig forRemoteAddress(InetSocketAddress remoteAddress) {
        return SmtpSessionConfig.builder().remoteAddress(remoteAddress).build();
    }
}

