/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.smtp.client.SmtpSessionFactoryConfig;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyStore;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(typeImmutable="*", visibility=Value.Style.ImplementationVisibility.PUBLIC)
abstract class AbstractSmtpSessionFactoryConfig {
    public static final Executor DIRECT_EXECUTOR = Runnable::run;
    private static final Supplier<SmtpSessionFactoryConfig> NON_PRODUCTION_CONFIG = Suppliers.memoize(AbstractSmtpSessionFactoryConfig::createNonProductionConfig);

    AbstractSmtpSessionFactoryConfig() {
    }

    private static SmtpSessionFactoryConfig createNonProductionConfig() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("niosmtpclient-%d").build();
        return SmtpSessionFactoryConfig.builder().eventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, threadFactory)).executor(Executors.newCachedThreadPool(threadFactory)).build();
    }

    public static SmtpSessionFactoryConfig nonProductionConfig() {
        return (SmtpSessionFactoryConfig)NON_PRODUCTION_CONFIG.get();
    }

    public abstract Executor getExecutor();

    public abstract EventLoopGroup getEventLoopGroup();

    @Value.Default
    public ByteBufAllocator getAllocator() {
        return PooledByteBufAllocator.DEFAULT;
    }

    @Value.Default
    public java.util.function.Supplier<SSLEngine> getSslEngineSupplier() {
        return this::createSSLEngine;
    }

    @Value.Default
    public Class<? extends Channel> getChannelClass() {
        return NioSocketChannel.class;
    }

    private SSLEngine createSSLEngine() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            return SslContextBuilder.forClient().trustManager(trustManagerFactory).build().newEngine(this.getAllocator());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create SSLEngine", e);
        }
    }
}

