/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hubspot.smtp.client.SendInterceptor;
import io.netty.handler.codec.smtp.SmtpRequest;
import io.netty.handler.codec.smtp.SmtpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class CompositeSendInterceptor
implements SendInterceptor {
    private final SendInterceptor rootInterceptor;
    private final List<SendInterceptor> sendInterceptors;

    public static CompositeSendInterceptor of(SendInterceptor ... sendInterceptors) {
        return new CompositeSendInterceptor(Lists.newArrayList((Object[])sendInterceptors));
    }

    public static CompositeSendInterceptor of(List<SendInterceptor> interceptors) {
        return new CompositeSendInterceptor(interceptors);
    }

    private CompositeSendInterceptor(List<SendInterceptor> sendInterceptors) {
        Preconditions.checkNotNull(sendInterceptors);
        Preconditions.checkArgument((!sendInterceptors.isEmpty() ? 1 : 0) != 0, (Object)"sendInterceptors must not be empty");
        SendInterceptor rootInterceptor = sendInterceptors.get(0);
        for (int i = 1; i < sendInterceptors.size(); ++i) {
            rootInterceptor = new InterceptorWrapper(rootInterceptor, sendInterceptors.get(i));
        }
        this.rootInterceptor = rootInterceptor;
        this.sendInterceptors = sendInterceptors;
    }

    @VisibleForTesting
    public List<SendInterceptor> getSendInterceptors() {
        return this.sendInterceptors;
    }

    @Override
    public CompletableFuture<List<SmtpResponse>> aroundRequest(SmtpRequest request, Supplier<CompletableFuture<List<SmtpResponse>>> next) {
        return this.rootInterceptor.aroundRequest(request, next);
    }

    @Override
    public CompletableFuture<List<SmtpResponse>> aroundData(Supplier<CompletableFuture<List<SmtpResponse>>> next) {
        return this.rootInterceptor.aroundData(next);
    }

    @Override
    public CompletableFuture<List<SmtpResponse>> aroundPipelinedSequence(List<SmtpRequest> requests, Supplier<CompletableFuture<List<SmtpResponse>>> next) {
        return this.rootInterceptor.aroundPipelinedSequence(requests, next);
    }

    private static class InterceptorWrapper
    implements SendInterceptor {
        private final SendInterceptor thisInterceptor;
        private final SendInterceptor nextInterceptor;

        InterceptorWrapper(SendInterceptor thisInterceptor, SendInterceptor nextInterceptor) {
            this.thisInterceptor = thisInterceptor;
            this.nextInterceptor = nextInterceptor;
        }

        @Override
        public CompletableFuture<List<SmtpResponse>> aroundRequest(SmtpRequest request, Supplier<CompletableFuture<List<SmtpResponse>>> next) {
            return this.thisInterceptor.aroundRequest(request, () -> this.nextInterceptor.aroundRequest(request, next));
        }

        @Override
        public CompletableFuture<List<SmtpResponse>> aroundData(Supplier<CompletableFuture<List<SmtpResponse>>> next) {
            return this.thisInterceptor.aroundData(() -> this.nextInterceptor.aroundData(next));
        }

        @Override
        public CompletableFuture<List<SmtpResponse>> aroundPipelinedSequence(List<SmtpRequest> requests, Supplier<CompletableFuture<List<SmtpResponse>>> next) {
            return this.thisInterceptor.aroundPipelinedSequence(requests, () -> this.nextInterceptor.aroundPipelinedSequence(requests, next));
        }
    }
}

