/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import com.hubspot.smtp.client.Extension;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class EhloResponse {
    static final EhloResponse EMPTY = EhloResponse.parse("", Collections.emptyList());
    private static final Splitter WHITESPACE_SPLITTER = Splitter.on((CharMatcher)CharMatcher.whitespace());
    private final String ehloDomain;
    private final ImmutableSet<String> supportedExtensions;
    private EnumSet<Extension> extensions;
    private Optional<Long> maxMessageSize = Optional.empty();
    private boolean isAuthPlainSupported;
    private boolean isAuthLoginSupported;
    private boolean isAuthXoauth2Supported;

    public static EhloResponse parse(String ehloDomain, Iterable<CharSequence> lines) {
        return EhloResponse.parse(ehloDomain, lines, EnumSet.noneOf(Extension.class));
    }

    public static EhloResponse parse(String ehloDomain, Iterable<CharSequence> lines, EnumSet<Extension> disabledExtensions) {
        return new EhloResponse(ehloDomain, lines, disabledExtensions);
    }

    private EhloResponse(String ehloDomain, Iterable<CharSequence> lines, EnumSet<Extension> disabledExtensions) {
        this.ehloDomain = ehloDomain;
        this.extensions = EnumSet.noneOf(Extension.class);
        for (CharSequence line : lines) {
            List parts = WHITESPACE_SPLITTER.splitToList(line);
            Optional<Extension> ext = Extension.find((String)parts.get(0));
            if (ext.isPresent()) {
                if (disabledExtensions.contains((Object)ext.get())) continue;
                this.extensions.add(ext.get());
            }
            switch (((String)parts.get(0)).toLowerCase()) {
                case "auth": {
                    this.parseAuth(parts);
                    break;
                }
                case "size": {
                    this.parseSize(parts);
                    break;
                }
            }
        }
        this.supportedExtensions = ImmutableSet.copyOf((Iterable)Iterables.transform(lines, CharSequence::toString));
    }

    private void parseSize(List<String> parts) {
        Optional<Long> maybeSize;
        if (parts.size() > 1 && (maybeSize = Optional.ofNullable(Longs.tryParse((String)parts.get(1)))).isPresent() && maybeSize.get() > 0L) {
            this.maxMessageSize = maybeSize;
        }
    }

    private void parseAuth(List<String> parts) {
        for (String s : parts) {
            if (s.equalsIgnoreCase("plain")) {
                this.isAuthPlainSupported = true;
                continue;
            }
            if (s.equalsIgnoreCase("login")) {
                this.isAuthLoginSupported = true;
                continue;
            }
            if (!s.equalsIgnoreCase("xoauth2")) continue;
            this.isAuthXoauth2Supported = true;
        }
    }

    public String getEhloDomain() {
        return this.ehloDomain;
    }

    public boolean isSupported(Extension ext) {
        return this.extensions.contains((Object)ext);
    }

    public boolean isAuthPlainSupported() {
        return this.isAuthPlainSupported;
    }

    public boolean isAuthLoginSupported() {
        return this.isAuthLoginSupported;
    }

    public boolean isAuthXoauth2Supported() {
        return this.isAuthXoauth2Supported;
    }

    public Optional<Long> getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Set<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

