/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.hubspot.smtp.client.KeepAliveHandler;
import com.hubspot.smtp.client.ResponseHandler;
import com.hubspot.smtp.client.SmtpSessionConfig;
import com.hubspot.smtp.client.Utf8SmtpRequestEncoder;
import com.hubspot.smtp.client.Utf8SmtpResponseDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.time.Duration;
import java.util.ArrayList;

class Initializer
extends ChannelInitializer<SocketChannel> {
    private static final int MAX_LINE_LENGTH = 1000;
    private final ResponseHandler responseHandler;
    private final SmtpSessionConfig config;

    Initializer(ResponseHandler responseHandler, SmtpSessionConfig config) {
        this.responseHandler = responseHandler;
        this.config = config;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        socketChannel.pipeline().addLast(this.getChannelHandlers());
        socketChannel.pipeline().addFirst(this.config.getAddFirstCustomHandlers());
    }

    private ChannelHandler[] getChannelHandlers() {
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add((Object)new Utf8SmtpRequestEncoder());
        handlers.add((Object)new Utf8SmtpResponseDecoder(1000));
        handlers.add(new ChunkedWriteHandler());
        this.config.getKeepAliveTimeout().ifPresent(timeout -> handlers.add((Object)new KeepAliveHandler(this.responseHandler, this.config.getConnectionId(), (Duration)timeout)));
        handlers.add((Object)this.responseHandler);
        return handlers.toArray(new ChannelHandler[handlers.size()]);
    }
}

