/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.collect.Lists;
import com.hubspot.smtp.client.NoopErrorResponseException;
import com.hubspot.smtp.client.ResponseHandler;
import com.hubspot.smtp.utils.SmtpResponses;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.smtp.DefaultSmtpRequest;
import io.netty.handler.codec.smtp.SmtpCommand;
import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAliveHandler
extends IdleStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveHandler.class);
    private final ResponseHandler responseHandler;
    private final String connectionId;
    private final List<PendingWrite> pendingWrites = Lists.newArrayList();
    private boolean expectingNoopResponse;

    KeepAliveHandler(ResponseHandler responseHandler, String connectionId, Duration idleTimeout) {
        super(0, 0, Math.toIntExact(idleTimeout.getSeconds()));
        this.responseHandler = responseHandler;
        this.connectionId = connectionId;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        LOG.debug("[{}] Sending NOOP to keep the connection alive", (Object)this.connectionId);
        if (this.expectingNoopResponse) {
            LOG.warn("[{}] Did not receive a response to our last NOOP, will not send another", (Object)this.connectionId);
            return;
        }
        Optional<String> debugString = this.responseHandler.getPendingResponseDebugString();
        if (debugString.isPresent()) {
            LOG.warn("[{}] Waiting for a response to [{}], will not send a NOOP to keep the connection alive", (Object)this.connectionId, (Object)debugString.get());
        } else {
            LOG.debug("[{}] Sending NOOP", (Object)this.connectionId);
            ctx.channel().writeAndFlush((Object)new DefaultSmtpRequest(SmtpCommand.NOOP));
            this.expectingNoopResponse = true;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.expectingNoopResponse && msg instanceof SmtpResponse) {
            LOG.debug("[{}] NOOP response received {}", (Object)this.connectionId, (Object)SmtpResponses.toString((SmtpResponse)msg));
            this.swallowNoopResponse((SmtpResponse)msg);
            this.sendPendingWrites(ctx);
            return;
        }
        super.channelRead(ctx, msg);
    }

    private void swallowNoopResponse(SmtpResponse response) throws NoopErrorResponseException {
        this.expectingNoopResponse = false;
        if (SmtpResponses.isError(response)) {
            LOG.warn("[{}] Received error {} in response to NOOP", (Object)this.connectionId, (Object)SmtpResponses.toString(response));
            throw new NoopErrorResponseException(this.connectionId, response, "Received error in response to NOOP");
        }
    }

    private void sendPendingWrites(ChannelHandlerContext ctx) throws Exception {
        for (PendingWrite w : this.pendingWrites) {
            this.write(ctx, w.msg, w.promise);
        }
        this.pendingWrites.clear();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.expectingNoopResponse) {
            this.pendingWrites.add(new PendingWrite(msg, promise));
            return;
        }
        super.write(ctx, msg, promise);
    }

    private static class PendingWrite {
        private Object msg;
        private ChannelPromise promise;

        PendingWrite(Object msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }
    }
}

