/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hubspot.smtp.client.ResponseException;
import io.netty.handler.codec.smtp.SmtpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

class ResponseCollector {
    private final CompletableFuture<List<SmtpResponse>> future;
    private final List<SmtpResponse> responses;
    private final Supplier<String> debugString;
    private int remainingResponses;

    ResponseCollector(int expectedResponses, Supplier<String> debugString) {
        this.remainingResponses = expectedResponses;
        this.debugString = debugString;
        this.responses = Lists.newArrayListWithExpectedSize((int)expectedResponses);
        this.future = new CompletableFuture();
    }

    CompletableFuture<List<SmtpResponse>> getFuture() {
        return this.future;
    }

    public String getDebugString() {
        return this.debugString.get();
    }

    boolean addResponse(SmtpResponse response) {
        Preconditions.checkState((this.remainingResponses > 0 ? 1 : 0) != 0, (Object)"All the responses have already been collected");
        --this.remainingResponses;
        this.responses.add(response);
        return this.remainingResponses == 0;
    }

    void complete() {
        Preconditions.checkState((this.remainingResponses == 0 ? 1 : 0) != 0, (Object)("Still waiting for " + this.remainingResponses + " responses"));
        this.future.complete(this.responses);
    }

    void completeExceptionally(Throwable cause) {
        this.future.completeExceptionally(new ResponseException(cause, this.getDebugString(), this.responses));
    }
}

