/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.smtp.client.ChannelClosedException;
import com.hubspot.smtp.client.ResponseCollector;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseHandler
extends SimpleChannelInboundHandler<SmtpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHandler.class);
    private static final HashedWheelTimer TIMER = new HashedWheelTimer(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("response-timer-%d").build());
    private final AtomicReference<ResponseCollector> responseCollector = new AtomicReference();
    private final String connectionId;
    private final Optional<Duration> defaultResponseTimeout;
    private final Optional<Consumer<Throwable>> exceptionHandler;

    ResponseHandler(String connectionId, Optional<Duration> defaultResponseTimeout, Optional<Consumer<Throwable>> exceptionHandler) {
        this.connectionId = connectionId;
        this.defaultResponseTimeout = defaultResponseTimeout;
        this.exceptionHandler = exceptionHandler;
    }

    CompletableFuture<List<SmtpResponse>> createResponseFuture(int expectedResponses, Supplier<String> debugStringSupplier) {
        return this.createResponseFuture(expectedResponses, this.defaultResponseTimeout, debugStringSupplier);
    }

    CompletableFuture<List<SmtpResponse>> createResponseFuture(int expectedResponses, Optional<Duration> responseTimeout, Supplier<String> debugStringSupplier) {
        ResponseCollector collector = new ResponseCollector(expectedResponses, debugStringSupplier);
        boolean success = this.responseCollector.compareAndSet(null, collector);
        if (!success) {
            ResponseCollector previousCollector = this.responseCollector.get();
            if (previousCollector == null) {
                return this.createResponseFuture(expectedResponses, debugStringSupplier);
            }
            throw new IllegalStateException(String.format("[%s] Cannot wait for a response to [%s] because we're still waiting for a response to [%s]", this.connectionId, collector.getDebugString(), previousCollector.getDebugString()));
        }
        CompletableFuture<List<SmtpResponse>> responseFuture = collector.getFuture();
        this.applyResponseTimeout(responseFuture, responseTimeout, debugStringSupplier);
        return responseFuture;
    }

    private void applyResponseTimeout(CompletableFuture<List<SmtpResponse>> responseFuture, Optional<Duration> responseTimeout, Supplier<String> debugStringSupplier) {
        responseTimeout = responseTimeout.isPresent() ? responseTimeout : this.defaultResponseTimeout;
        responseTimeout.ifPresent(timeout -> {
            Timeout hwtTimeout = TIMER.newTimeout(arg_0 -> this.lambda$applyResponseTimeout$0((Supplier)debugStringSupplier, responseFuture, arg_0), timeout.toMillis(), TimeUnit.MILLISECONDS);
            responseFuture.whenComplete((ignored1, ignored2) -> hwtTimeout.cancel());
        });
    }

    Optional<String> getPendingResponseDebugString() {
        return Optional.ofNullable(this.responseCollector.get()).map(ResponseCollector::getDebugString);
    }

    protected void channelRead0(ChannelHandlerContext ctx, SmtpResponse msg) throws Exception {
        ResponseCollector collector = this.responseCollector.get();
        if (collector == null) {
            LOG.warn("[{}] Unexpected response received: {}", (Object)this.connectionId, (Object)msg);
        } else {
            boolean complete = collector.addResponse(msg);
            if (complete) {
                this.responseCollector.set(null);
                collector.complete();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ResponseCollector collector;
        if (cause instanceof ReadTimeoutException) {
            LOG.warn("[{}] The channel was closed because a read timed out", (Object)this.connectionId);
        }
        if ((collector = (ResponseCollector)this.responseCollector.getAndSet(null)) != null) {
            collector.completeExceptionally(cause);
        } else if (this.exceptionHandler.isPresent()) {
            this.exceptionHandler.get().accept(cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ResponseCollector collector = this.responseCollector.get();
        if (collector != null) {
            collector.completeExceptionally(new ChannelClosedException(this.connectionId, "Handled channelInactive while waiting for a response to [" + collector.getDebugString() + "]"));
        }
        super.channelInactive(ctx);
    }

    private /* synthetic */ void lambda$applyResponseTimeout$0(Supplier debugStringSupplier, CompletableFuture responseFuture, Timeout ignored) throws Exception {
        String message = String.format("[%s] Timed out waiting for a response to [%s]", this.connectionId, debugStringSupplier.get());
        responseFuture.completeExceptionally(new TimeoutException(message));
    }
}

