/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.collect.ImmutableList;
import com.hubspot.smtp.client.SmtpSession;
import com.hubspot.smtp.utils.SmtpResponses;
import io.netty.handler.codec.smtp.SmtpResponse;
import java.util.List;
import java.util.stream.Collectors;

public class SmtpClientResponse {
    private final SmtpSession session;
    private final List<SmtpResponse> responses;

    public SmtpClientResponse(SmtpSession session, SmtpResponse response) {
        this.responses = ImmutableList.of((Object)response);
        this.session = session;
    }

    public SmtpClientResponse(SmtpSession session, Iterable<SmtpResponse> responses) {
        this.responses = ImmutableList.copyOf(responses);
        this.session = session;
    }

    public SmtpClientResponse(SmtpSession session, List<SmtpResponse> responses) {
        this.responses = ImmutableList.copyOf(responses);
        this.session = session;
    }

    public SmtpSession getSession() {
        return this.session;
    }

    public boolean containsError() {
        return this.responses.stream().anyMatch(SmtpResponses::isError);
    }

    public List<SmtpResponse> getResponses() {
        return this.responses;
    }

    public String toString() {
        return this.responses.stream().map(SmtpResponses::toString).collect(Collectors.joining("; "));
    }
}

