/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.hubspot.smtp.client.AbstractSmtpSessionConfig;
import com.hubspot.smtp.client.Extension;
import com.hubspot.smtp.client.SendInterceptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractSmtpSessionConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SmtpSessionConfig
extends AbstractSmtpSessionConfig {
    private final InetSocketAddress remoteAddress;
    @Nullable
    private final InetSocketAddress localAddress;
    @Nullable
    private final Duration keepAliveTimeout;
    @Nullable
    private final Duration readTimeout;
    @Nullable
    private final Duration initialResponseReadTimeout;
    private final Duration initialResponseTimeout;
    @Nullable
    private final SendInterceptor sendInterceptor;
    @Nullable
    private final Consumer<Throwable> exceptionHandler;
    private final Duration connectionTimeout;
    private final EnumSet<Extension> disabledExtensions;
    private final String connectionId;
    private final ChannelHandler[] addFirstCustomHandlers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SmtpSessionConfig(Builder builder) {
        this.remoteAddress = builder.remoteAddress;
        this.localAddress = builder.localAddress;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.readTimeout = builder.readTimeout;
        this.initialResponseReadTimeout = builder.initialResponseReadTimeout;
        this.sendInterceptor = builder.sendInterceptor;
        this.exceptionHandler = builder.exceptionHandler;
        if (builder.initialResponseTimeout != null) {
            this.initShim.initialResponseTimeout(builder.initialResponseTimeout);
        }
        if (builder.connectionTimeout != null) {
            this.initShim.connectionTimeout(builder.connectionTimeout);
        }
        if (builder.disabledExtensions != null) {
            this.initShim.disabledExtensions(builder.disabledExtensions);
        }
        if (builder.connectionId != null) {
            this.initShim.connectionId(builder.connectionId);
        }
        if (builder.addFirstCustomHandlers != null) {
            this.initShim.addFirstCustomHandlers(builder.addFirstCustomHandlers);
        }
        this.initialResponseTimeout = this.initShim.getInitialResponseTimeout();
        this.connectionTimeout = this.initShim.getConnectionTimeout();
        this.disabledExtensions = this.initShim.getDisabledExtensions();
        this.connectionId = this.initShim.getConnectionId();
        this.addFirstCustomHandlers = this.initShim.getAddFirstCustomHandlers();
        this.initShim = null;
    }

    private SmtpSessionConfig(InetSocketAddress remoteAddress, @Nullable InetSocketAddress localAddress, @Nullable Duration keepAliveTimeout, @Nullable Duration readTimeout, @Nullable Duration initialResponseReadTimeout, Duration initialResponseTimeout, @Nullable SendInterceptor sendInterceptor, @Nullable Consumer<Throwable> exceptionHandler, Duration connectionTimeout, EnumSet<Extension> disabledExtensions, String connectionId, ChannelHandler[] addFirstCustomHandlers) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.keepAliveTimeout = keepAliveTimeout;
        this.readTimeout = readTimeout;
        this.initialResponseReadTimeout = initialResponseReadTimeout;
        this.initialResponseTimeout = initialResponseTimeout;
        this.sendInterceptor = sendInterceptor;
        this.exceptionHandler = exceptionHandler;
        this.connectionTimeout = connectionTimeout;
        this.disabledExtensions = disabledExtensions;
        this.connectionId = connectionId;
        this.addFirstCustomHandlers = addFirstCustomHandlers;
        this.initShim = null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Optional<InetSocketAddress> getLocalAddress() {
        return Optional.ofNullable(this.localAddress);
    }

    @Override
    public Optional<Duration> getKeepAliveTimeout() {
        return Optional.ofNullable(this.keepAliveTimeout);
    }

    @Override
    public Optional<Duration> getReadTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    @Override
    @Deprecated
    public Optional<Duration> getInitialResponseReadTimeout() {
        return Optional.ofNullable(this.initialResponseReadTimeout);
    }

    @Override
    public Duration getInitialResponseTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInitialResponseTimeout() : this.initialResponseTimeout;
    }

    @Override
    public Optional<SendInterceptor> getSendInterceptor() {
        return Optional.ofNullable(this.sendInterceptor);
    }

    @Override
    public Optional<Consumer<Throwable>> getExceptionHandler() {
        return Optional.ofNullable(this.exceptionHandler);
    }

    @Override
    @Deprecated
    public Duration getConnectionTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectionTimeout() : this.connectionTimeout;
    }

    @Override
    public EnumSet<Extension> getDisabledExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDisabledExtensions() : this.disabledExtensions;
    }

    @Override
    public String getConnectionId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectionId() : this.connectionId;
    }

    @Override
    public ChannelHandler[] getAddFirstCustomHandlers() {
        InitShim shim = this.initShim;
        return shim != null ? (ChannelHandler[])shim.getAddFirstCustomHandlers().clone() : (ChannelHandler[])this.addFirstCustomHandlers.clone();
    }

    public final SmtpSessionConfig withRemoteAddress(InetSocketAddress value) {
        if (this.remoteAddress == value) {
            return this;
        }
        InetSocketAddress newValue = Objects.requireNonNull(value, "remoteAddress");
        return SmtpSessionConfig.validate(new SmtpSessionConfig(newValue, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withLocalAddress(InetSocketAddress value) {
        InetSocketAddress newValue = Objects.requireNonNull(value, "localAddress");
        if (this.localAddress == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, newValue, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withLocalAddress(Optional<? extends InetSocketAddress> optional) {
        InetSocketAddress value = optional.orElse(null);
        if (this.localAddress == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, value, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withKeepAliveTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "keepAliveTimeout");
        if (this.keepAliveTimeout == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, newValue, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withKeepAliveTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.keepAliveTimeout == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, value, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withReadTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "readTimeout");
        if (this.readTimeout == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, newValue, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withReadTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.readTimeout == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, value, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    @Deprecated
    public final SmtpSessionConfig withInitialResponseReadTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "initialResponseReadTimeout");
        if (this.initialResponseReadTimeout == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, newValue, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    @Deprecated
    public final SmtpSessionConfig withInitialResponseReadTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.initialResponseReadTimeout == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, value, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withInitialResponseTimeout(Duration value) {
        if (this.initialResponseTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "initialResponseTimeout");
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, newValue, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withSendInterceptor(SendInterceptor value) {
        SendInterceptor newValue = Objects.requireNonNull(value, "sendInterceptor");
        if (this.sendInterceptor == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, newValue, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withSendInterceptor(Optional<? extends SendInterceptor> optional) {
        SendInterceptor value = optional.orElse(null);
        if (this.sendInterceptor == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, value, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withExceptionHandler(Consumer<Throwable> value) {
        Consumer<Throwable> newValue = Objects.requireNonNull(value, "exceptionHandler");
        if (this.exceptionHandler == newValue) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, newValue, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withExceptionHandler(Optional<? extends Consumer<Throwable>> optional) {
        Consumer value = optional.orElse(null);
        if (this.exceptionHandler == value) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, value, this.connectionTimeout, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    @Deprecated
    public final SmtpSessionConfig withConnectionTimeout(Duration value) {
        if (this.connectionTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "connectionTimeout");
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, newValue, this.disabledExtensions, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withDisabledExtensions(EnumSet<Extension> value) {
        if (this.disabledExtensions == value) {
            return this;
        }
        EnumSet<Extension> newValue = Objects.requireNonNull(value, "disabledExtensions");
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, newValue, this.connectionId, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withConnectionId(String value) {
        String newValue = Objects.requireNonNull(value, "connectionId");
        if (this.connectionId.equals(newValue)) {
            return this;
        }
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, newValue, this.addFirstCustomHandlers));
    }

    public final SmtpSessionConfig withAddFirstCustomHandlers(ChannelHandler ... elements) {
        ChannelHandler[] newValue = (ChannelHandler[])elements.clone();
        return SmtpSessionConfig.validate(new SmtpSessionConfig(this.remoteAddress, this.localAddress, this.keepAliveTimeout, this.readTimeout, this.initialResponseReadTimeout, this.initialResponseTimeout, this.sendInterceptor, this.exceptionHandler, this.connectionTimeout, this.disabledExtensions, this.connectionId, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SmtpSessionConfig && this.equalTo((SmtpSessionConfig)another);
    }

    private boolean equalTo(SmtpSessionConfig another) {
        return this.remoteAddress.equals(another.remoteAddress) && Objects.equals(this.localAddress, another.localAddress) && Objects.equals(this.keepAliveTimeout, another.keepAliveTimeout) && Objects.equals(this.readTimeout, another.readTimeout) && Objects.equals(this.initialResponseReadTimeout, another.initialResponseReadTimeout) && this.initialResponseTimeout.equals(another.initialResponseTimeout) && Objects.equals(this.sendInterceptor, another.sendInterceptor) && Objects.equals(this.exceptionHandler, another.exceptionHandler) && this.connectionTimeout.equals(another.connectionTimeout) && this.disabledExtensions.equals(another.disabledExtensions) && this.connectionId.equals(another.connectionId) && Arrays.equals(this.addFirstCustomHandlers, another.addFirstCustomHandlers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.remoteAddress.hashCode();
        h += (h << 5) + Objects.hashCode(this.localAddress);
        h += (h << 5) + Objects.hashCode(this.keepAliveTimeout);
        h += (h << 5) + Objects.hashCode(this.readTimeout);
        h += (h << 5) + Objects.hashCode(this.initialResponseReadTimeout);
        h += (h << 5) + this.initialResponseTimeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.sendInterceptor);
        h += (h << 5) + Objects.hashCode(this.exceptionHandler);
        h += (h << 5) + this.connectionTimeout.hashCode();
        h += (h << 5) + this.disabledExtensions.hashCode();
        h += (h << 5) + this.connectionId.hashCode();
        h += (h << 5) + Arrays.hashCode(this.addFirstCustomHandlers);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SmtpSessionConfig").omitNullValues().add("remoteAddress", (Object)this.remoteAddress).add("localAddress", (Object)this.localAddress).add("keepAliveTimeout", (Object)this.keepAliveTimeout).add("readTimeout", (Object)this.readTimeout).add("initialResponseReadTimeout", (Object)this.initialResponseReadTimeout).add("initialResponseTimeout", (Object)this.initialResponseTimeout).add("sendInterceptor", (Object)this.sendInterceptor).add("exceptionHandler", this.exceptionHandler).add("connectionTimeout", (Object)this.connectionTimeout).add("disabledExtensions", this.disabledExtensions).add("connectionId", (Object)this.connectionId).add("addFirstCustomHandlers", (Object)Arrays.toString(this.addFirstCustomHandlers)).toString();
    }

    private static SmtpSessionConfig validate(SmtpSessionConfig instance) {
        instance.check();
        return instance;
    }

    static SmtpSessionConfig copyOf(AbstractSmtpSessionConfig instance) {
        if (instance instanceof SmtpSessionConfig) {
            return (SmtpSessionConfig)instance;
        }
        return SmtpSessionConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractSmtpSessionConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REMOTE_ADDRESS = 1L;
        private long initBits = 1L;
        @Nullable
        private InetSocketAddress remoteAddress;
        @Nullable
        private InetSocketAddress localAddress;
        @Nullable
        private Duration keepAliveTimeout;
        @Nullable
        private Duration readTimeout;
        @Nullable
        private Duration initialResponseReadTimeout;
        @Nullable
        private Duration initialResponseTimeout;
        @Nullable
        private SendInterceptor sendInterceptor;
        @Nullable
        private Consumer<Throwable> exceptionHandler;
        @Nullable
        private Duration connectionTimeout;
        @Nullable
        private EnumSet<Extension> disabledExtensions;
        @Nullable
        private String connectionId;
        @Nullable
        private ChannelHandler[] addFirstCustomHandlers;

        private Builder() {
        }

        public final Builder from(SmtpSessionConfig instance) {
            return this.from((AbstractSmtpSessionConfig)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(AbstractSmtpSessionConfig instance) {
            Optional<Consumer<Throwable>> exceptionHandlerOptional;
            Optional<Duration> initialResponseReadTimeoutOptional;
            Optional<Duration> readTimeoutOptional;
            Optional<Duration> keepAliveTimeoutOptional;
            Objects.requireNonNull(instance, "instance");
            this.remoteAddress(instance.getRemoteAddress());
            Optional<InetSocketAddress> localAddressOptional = instance.getLocalAddress();
            if (localAddressOptional.isPresent()) {
                this.localAddress(localAddressOptional);
            }
            if ((keepAliveTimeoutOptional = instance.getKeepAliveTimeout()).isPresent()) {
                this.keepAliveTimeout(keepAliveTimeoutOptional);
            }
            if ((readTimeoutOptional = instance.getReadTimeout()).isPresent()) {
                this.readTimeout(readTimeoutOptional);
            }
            if ((initialResponseReadTimeoutOptional = instance.getInitialResponseReadTimeout()).isPresent()) {
                this.initialResponseReadTimeout(initialResponseReadTimeoutOptional);
            }
            this.initialResponseTimeout(instance.getInitialResponseTimeout());
            Optional<SendInterceptor> sendInterceptorOptional = instance.getSendInterceptor();
            if (sendInterceptorOptional.isPresent()) {
                this.sendInterceptor(sendInterceptorOptional);
            }
            if ((exceptionHandlerOptional = instance.getExceptionHandler()).isPresent()) {
                this.exceptionHandler(exceptionHandlerOptional);
            }
            this.connectionTimeout(instance.getConnectionTimeout());
            this.disabledExtensions(instance.getDisabledExtensions());
            this.connectionId(instance.getConnectionId());
            this.addFirstCustomHandlers(instance.getAddFirstCustomHandlers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remoteAddress(InetSocketAddress remoteAddress) {
            this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localAddress(InetSocketAddress localAddress) {
            this.localAddress = Objects.requireNonNull(localAddress, "localAddress");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localAddress(Optional<? extends InetSocketAddress> localAddress) {
            this.localAddress = localAddress.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = Objects.requireNonNull(keepAliveTimeout, "keepAliveTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keepAliveTimeout(Optional<? extends Duration> keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder readTimeout(Duration readTimeout) {
            this.readTimeout = Objects.requireNonNull(readTimeout, "readTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder readTimeout(Optional<? extends Duration> readTimeout) {
            this.readTimeout = readTimeout.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder initialResponseReadTimeout(Duration initialResponseReadTimeout) {
            this.initialResponseReadTimeout = Objects.requireNonNull(initialResponseReadTimeout, "initialResponseReadTimeout");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder initialResponseReadTimeout(Optional<? extends Duration> initialResponseReadTimeout) {
            this.initialResponseReadTimeout = initialResponseReadTimeout.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialResponseTimeout(Duration initialResponseTimeout) {
            this.initialResponseTimeout = Objects.requireNonNull(initialResponseTimeout, "initialResponseTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sendInterceptor(SendInterceptor sendInterceptor) {
            this.sendInterceptor = Objects.requireNonNull(sendInterceptor, "sendInterceptor");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sendInterceptor(Optional<? extends SendInterceptor> sendInterceptor) {
            this.sendInterceptor = sendInterceptor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exceptionHandler(Consumer<Throwable> exceptionHandler) {
            this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exceptionHandler(Optional<? extends Consumer<Throwable>> exceptionHandler) {
            this.exceptionHandler = exceptionHandler.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = Objects.requireNonNull(connectionTimeout, "connectionTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledExtensions(EnumSet<Extension> disabledExtensions) {
            this.disabledExtensions = Objects.requireNonNull(disabledExtensions, "disabledExtensions");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionId(String connectionId) {
            this.connectionId = Objects.requireNonNull(connectionId, "connectionId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFirstCustomHandlers(ChannelHandler ... addFirstCustomHandlers) {
            this.addFirstCustomHandlers = (ChannelHandler[])addFirstCustomHandlers.clone();
            return this;
        }

        public SmtpSessionConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return SmtpSessionConfig.validate(new SmtpSessionConfig(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("remoteAddress");
            }
            return "Cannot build SmtpSessionConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AbstractSmtpSessionConfig", generator="Immutables")
    private final class InitShim {
        private byte initialResponseTimeoutBuildStage = 0;
        private Duration initialResponseTimeout;
        private byte connectionTimeoutBuildStage = 0;
        private Duration connectionTimeout;
        private byte disabledExtensionsBuildStage = 0;
        private EnumSet<Extension> disabledExtensions;
        private byte connectionIdBuildStage = 0;
        private String connectionId;
        private byte addFirstCustomHandlersBuildStage = 0;
        private ChannelHandler[] addFirstCustomHandlers;

        private InitShim() {
        }

        Duration getInitialResponseTimeout() {
            if (this.initialResponseTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialResponseTimeoutBuildStage == 0) {
                this.initialResponseTimeoutBuildStage = (byte)-1;
                this.initialResponseTimeout = Objects.requireNonNull(SmtpSessionConfig.super.getInitialResponseTimeout(), "initialResponseTimeout");
                this.initialResponseTimeoutBuildStage = 1;
            }
            return this.initialResponseTimeout;
        }

        void initialResponseTimeout(Duration initialResponseTimeout) {
            this.initialResponseTimeout = initialResponseTimeout;
            this.initialResponseTimeoutBuildStage = 1;
        }

        Duration getConnectionTimeout() {
            if (this.connectionTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectionTimeoutBuildStage == 0) {
                this.connectionTimeoutBuildStage = (byte)-1;
                this.connectionTimeout = Objects.requireNonNull(SmtpSessionConfig.super.getConnectionTimeout(), "connectionTimeout");
                this.connectionTimeoutBuildStage = 1;
            }
            return this.connectionTimeout;
        }

        void connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.connectionTimeoutBuildStage = 1;
        }

        EnumSet<Extension> getDisabledExtensions() {
            if (this.disabledExtensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disabledExtensionsBuildStage == 0) {
                this.disabledExtensionsBuildStage = (byte)-1;
                this.disabledExtensions = Objects.requireNonNull(SmtpSessionConfig.super.getDisabledExtensions(), "disabledExtensions");
                this.disabledExtensionsBuildStage = 1;
            }
            return this.disabledExtensions;
        }

        void disabledExtensions(EnumSet<Extension> disabledExtensions) {
            this.disabledExtensions = disabledExtensions;
            this.disabledExtensionsBuildStage = 1;
        }

        String getConnectionId() {
            if (this.connectionIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectionIdBuildStage == 0) {
                this.connectionIdBuildStage = (byte)-1;
                this.connectionId = Objects.requireNonNull(SmtpSessionConfig.super.getConnectionId(), "connectionId");
                this.connectionIdBuildStage = 1;
            }
            return this.connectionId;
        }

        void connectionId(String connectionId) {
            this.connectionId = connectionId;
            this.connectionIdBuildStage = 1;
        }

        ChannelHandler[] getAddFirstCustomHandlers() {
            if (this.addFirstCustomHandlersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addFirstCustomHandlersBuildStage == 0) {
                this.addFirstCustomHandlersBuildStage = (byte)-1;
                this.addFirstCustomHandlers = (ChannelHandler[])SmtpSessionConfig.super.getAddFirstCustomHandlers().clone();
                this.addFirstCustomHandlersBuildStage = 1;
            }
            return this.addFirstCustomHandlers;
        }

        void addFirstCustomHandlers(ChannelHandler[] addFirstCustomHandlers) {
            this.addFirstCustomHandlers = addFirstCustomHandlers;
            this.addFirstCustomHandlersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.initialResponseTimeoutBuildStage == -1) {
                attributes.add("initialResponseTimeout");
            }
            if (this.connectionTimeoutBuildStage == -1) {
                attributes.add("connectionTimeout");
            }
            if (this.disabledExtensionsBuildStage == -1) {
                attributes.add("disabledExtensions");
            }
            if (this.connectionIdBuildStage == -1) {
                attributes.add("connectionId");
            }
            if (this.addFirstCustomHandlersBuildStage == -1) {
                attributes.add("addFirstCustomHandlers");
            }
            return "Cannot build SmtpSessionConfig, attribute initializers form cycle " + attributes;
        }
    }
}

