/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.hubspot.smtp.client.Initializer;
import com.hubspot.smtp.client.ResponseHandler;
import com.hubspot.smtp.client.SmtpClientResponse;
import com.hubspot.smtp.client.SmtpSession;
import com.hubspot.smtp.client.SmtpSessionConfig;
import com.hubspot.smtp.client.SmtpSessionFactoryConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpSessionFactory
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpSessionFactory.class);
    private final ChannelGroup allChannels;
    private final SmtpSessionFactoryConfig factoryConfig;

    public SmtpSessionFactory(SmtpSessionFactoryConfig factoryConfig) {
        this.factoryConfig = factoryConfig;
        this.allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public CompletableFuture<SmtpClientResponse> connect(SmtpSessionConfig config) {
        ResponseHandler responseHandler = new ResponseHandler(config.getConnectionId(), config.getReadTimeout(), config.getExceptionHandler());
        CompletableFuture<List<SmtpResponse>> initialResponseFuture = responseHandler.createResponseFuture(1, Optional.of(config.getInitialResponseTimeout()), () -> "initial response");
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.factoryConfig.getEventLoopGroup())).channel(this.factoryConfig.getChannelClass())).option(ChannelOption.ALLOCATOR, (Object)this.factoryConfig.getAllocator())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)config.getInitialResponseTimeout().toMillis()))).remoteAddress((SocketAddress)config.getRemoteAddress()).localAddress((SocketAddress)config.getLocalAddress().orElse(null))).handler((ChannelHandler)new Initializer(responseHandler, config));
        CompletableFuture<SmtpClientResponse> connectFuture = new CompletableFuture<SmtpClientResponse>();
        bootstrap.connect().addListener(f -> {
            if (f.isSuccess()) {
                Channel channel = ((ChannelFuture)f).channel();
                this.allChannels.add((Object)channel);
                SmtpSession session = new SmtpSession(channel, responseHandler, config, this.factoryConfig.getExecutor(), this.factoryConfig.getSslEngineSupplier());
                initialResponseFuture.handleAsync((rs, e) -> {
                    if (e != null) {
                        session.close();
                        connectFuture.completeExceptionally((Throwable)e);
                    } else {
                        connectFuture.complete(new SmtpClientResponse(session, (SmtpResponse)rs.get(0)));
                    }
                    return null;
                }, this.factoryConfig.getExecutor());
            } else {
                this.factoryConfig.getExecutor().execute(() -> connectFuture.completeExceptionally(f.cause()));
            }
        });
        return connectFuture;
    }

    @Override
    public void close() throws IOException {
        try {
            this.allChannels.close().await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> returnedFuture = new CompletableFuture<Void>();
        this.allChannels.close().addListener(f -> {
            if (f.isSuccess()) {
                returnedFuture.complete(null);
            } else {
                returnedFuture.completeExceptionally(f.cause());
            }
        });
        return returnedFuture;
    }
}

