/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.hubspot.smtp.client.AbstractSmtpSessionFactoryConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLEngine;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractSmtpSessionFactoryConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SmtpSessionFactoryConfig
extends AbstractSmtpSessionFactoryConfig {
    private final Executor executor;
    private final EventLoopGroup eventLoopGroup;
    private final ByteBufAllocator allocator;
    private final Supplier<SSLEngine> sslEngineSupplier;
    private final Class<? extends Channel> channelClass;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SmtpSessionFactoryConfig(Builder builder) {
        this.executor = builder.executor;
        this.eventLoopGroup = builder.eventLoopGroup;
        if (builder.allocator != null) {
            this.initShim.allocator(builder.allocator);
        }
        if (builder.sslEngineSupplier != null) {
            this.initShim.sslEngineSupplier(builder.sslEngineSupplier);
        }
        if (builder.channelClass != null) {
            this.initShim.channelClass(builder.channelClass);
        }
        this.allocator = this.initShim.getAllocator();
        this.sslEngineSupplier = this.initShim.getSslEngineSupplier();
        this.channelClass = this.initShim.getChannelClass();
        this.initShim = null;
    }

    private SmtpSessionFactoryConfig(Executor executor, EventLoopGroup eventLoopGroup, ByteBufAllocator allocator, Supplier<SSLEngine> sslEngineSupplier, Class<? extends Channel> channelClass) {
        this.executor = executor;
        this.eventLoopGroup = eventLoopGroup;
        this.allocator = allocator;
        this.sslEngineSupplier = sslEngineSupplier;
        this.channelClass = channelClass;
        this.initShim = null;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ByteBufAllocator getAllocator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllocator() : this.allocator;
    }

    @Override
    public Supplier<SSLEngine> getSslEngineSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSslEngineSupplier() : this.sslEngineSupplier;
    }

    @Override
    public Class<? extends Channel> getChannelClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getChannelClass() : this.channelClass;
    }

    public final SmtpSessionFactoryConfig withExecutor(Executor value) {
        if (this.executor == value) {
            return this;
        }
        Executor newValue = Objects.requireNonNull(value, "executor");
        return new SmtpSessionFactoryConfig(newValue, this.eventLoopGroup, this.allocator, this.sslEngineSupplier, this.channelClass);
    }

    public final SmtpSessionFactoryConfig withEventLoopGroup(EventLoopGroup value) {
        if (this.eventLoopGroup == value) {
            return this;
        }
        EventLoopGroup newValue = Objects.requireNonNull(value, "eventLoopGroup");
        return new SmtpSessionFactoryConfig(this.executor, newValue, this.allocator, this.sslEngineSupplier, this.channelClass);
    }

    public final SmtpSessionFactoryConfig withAllocator(ByteBufAllocator value) {
        if (this.allocator == value) {
            return this;
        }
        ByteBufAllocator newValue = Objects.requireNonNull(value, "allocator");
        return new SmtpSessionFactoryConfig(this.executor, this.eventLoopGroup, newValue, this.sslEngineSupplier, this.channelClass);
    }

    public final SmtpSessionFactoryConfig withSslEngineSupplier(Supplier<SSLEngine> value) {
        if (this.sslEngineSupplier == value) {
            return this;
        }
        Supplier<SSLEngine> newValue = Objects.requireNonNull(value, "sslEngineSupplier");
        return new SmtpSessionFactoryConfig(this.executor, this.eventLoopGroup, this.allocator, newValue, this.channelClass);
    }

    public final SmtpSessionFactoryConfig withChannelClass(Class<? extends Channel> value) {
        if (this.channelClass == value) {
            return this;
        }
        Class<? extends Channel> newValue = Objects.requireNonNull(value, "channelClass");
        return new SmtpSessionFactoryConfig(this.executor, this.eventLoopGroup, this.allocator, this.sslEngineSupplier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SmtpSessionFactoryConfig && this.equalTo((SmtpSessionFactoryConfig)another);
    }

    private boolean equalTo(SmtpSessionFactoryConfig another) {
        return this.executor.equals(another.executor) && this.eventLoopGroup.equals(another.eventLoopGroup) && this.allocator.equals(another.allocator) && this.sslEngineSupplier.equals(another.sslEngineSupplier) && this.channelClass.equals(another.channelClass);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.executor.hashCode();
        h += (h << 5) + this.eventLoopGroup.hashCode();
        h += (h << 5) + this.allocator.hashCode();
        h += (h << 5) + this.sslEngineSupplier.hashCode();
        h += (h << 5) + this.channelClass.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SmtpSessionFactoryConfig").omitNullValues().add("executor", (Object)this.executor).add("eventLoopGroup", (Object)this.eventLoopGroup).add("allocator", (Object)this.allocator).add("sslEngineSupplier", this.sslEngineSupplier).add("channelClass", this.channelClass).toString();
    }

    static SmtpSessionFactoryConfig copyOf(AbstractSmtpSessionFactoryConfig instance) {
        if (instance instanceof SmtpSessionFactoryConfig) {
            return (SmtpSessionFactoryConfig)instance;
        }
        return SmtpSessionFactoryConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractSmtpSessionFactoryConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXECUTOR = 1L;
        private static final long INIT_BIT_EVENT_LOOP_GROUP = 2L;
        private long initBits = 3L;
        @Nullable
        private Executor executor;
        @Nullable
        private EventLoopGroup eventLoopGroup;
        @Nullable
        private ByteBufAllocator allocator;
        @Nullable
        private Supplier<SSLEngine> sslEngineSupplier;
        @Nullable
        private Class<? extends Channel> channelClass;

        private Builder() {
        }

        public final Builder from(SmtpSessionFactoryConfig instance) {
            return this.from((AbstractSmtpSessionFactoryConfig)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(AbstractSmtpSessionFactoryConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.executor(instance.getExecutor());
            this.eventLoopGroup(instance.getEventLoopGroup());
            this.allocator(instance.getAllocator());
            this.sslEngineSupplier(instance.getSslEngineSupplier());
            this.channelClass(instance.getChannelClass());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allocator(ByteBufAllocator allocator) {
            this.allocator = Objects.requireNonNull(allocator, "allocator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslEngineSupplier(Supplier<SSLEngine> sslEngineSupplier) {
            this.sslEngineSupplier = Objects.requireNonNull(sslEngineSupplier, "sslEngineSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelClass(Class<? extends Channel> channelClass) {
            this.channelClass = Objects.requireNonNull(channelClass, "channelClass");
            return this;
        }

        public SmtpSessionFactoryConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SmtpSessionFactoryConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("executor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventLoopGroup");
            }
            return "Cannot build SmtpSessionFactoryConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AbstractSmtpSessionFactoryConfig", generator="Immutables")
    private final class InitShim {
        private byte allocatorBuildStage = 0;
        private ByteBufAllocator allocator;
        private byte sslEngineSupplierBuildStage = 0;
        private Supplier<SSLEngine> sslEngineSupplier;
        private byte channelClassBuildStage = 0;
        private Class<? extends Channel> channelClass;

        private InitShim() {
        }

        ByteBufAllocator getAllocator() {
            if (this.allocatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allocatorBuildStage == 0) {
                this.allocatorBuildStage = (byte)-1;
                this.allocator = Objects.requireNonNull(SmtpSessionFactoryConfig.super.getAllocator(), "allocator");
                this.allocatorBuildStage = 1;
            }
            return this.allocator;
        }

        void allocator(ByteBufAllocator allocator) {
            this.allocator = allocator;
            this.allocatorBuildStage = 1;
        }

        Supplier<SSLEngine> getSslEngineSupplier() {
            if (this.sslEngineSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sslEngineSupplierBuildStage == 0) {
                this.sslEngineSupplierBuildStage = (byte)-1;
                this.sslEngineSupplier = Objects.requireNonNull(SmtpSessionFactoryConfig.super.getSslEngineSupplier(), "sslEngineSupplier");
                this.sslEngineSupplierBuildStage = 1;
            }
            return this.sslEngineSupplier;
        }

        void sslEngineSupplier(Supplier<SSLEngine> sslEngineSupplier) {
            this.sslEngineSupplier = sslEngineSupplier;
            this.sslEngineSupplierBuildStage = 1;
        }

        Class<? extends Channel> getChannelClass() {
            if (this.channelClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.channelClassBuildStage == 0) {
                this.channelClassBuildStage = (byte)-1;
                this.channelClass = Objects.requireNonNull(SmtpSessionFactoryConfig.super.getChannelClass(), "channelClass");
                this.channelClassBuildStage = 1;
            }
            return this.channelClass;
        }

        void channelClass(Class<? extends Channel> channelClass) {
            this.channelClass = channelClass;
            this.channelClassBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allocatorBuildStage == -1) {
                attributes.add("allocator");
            }
            if (this.sslEngineSupplierBuildStage == -1) {
                attributes.add("sslEngineSupplier");
            }
            if (this.channelClassBuildStage == -1) {
                attributes.add("channelClass");
            }
            return "Cannot build SmtpSessionFactoryConfig, attribute initializers form cycle " + attributes;
        }
    }
}

