/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.smtp.SmtpRequest;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class Utf8SmtpRequestEncoder
extends MessageToMessageEncoder<Object> {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte SP = 32;

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof SmtpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (!(msg instanceof SmtpRequest)) {
            return;
        }
        boolean release = true;
        ByteBuf buffer = ctx.alloc().buffer();
        try {
            SmtpRequest req = (SmtpRequest)msg;
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)req.command().name());
            Utf8SmtpRequestEncoder.writeParameters(req.parameters(), buffer);
            buffer.writeBytes(CRLF);
            out.add(buffer);
            release = false;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
    }

    private static void writeParameters(List<CharSequence> parameters, ByteBuf out) {
        if (parameters.isEmpty()) {
            return;
        }
        out.writeByte(32);
        if (parameters instanceof RandomAccess) {
            int sizeMinusOne = parameters.size() - 1;
            for (int i = 0; i < sizeMinusOne; ++i) {
                ByteBufUtil.writeUtf8((ByteBuf)out, (CharSequence)parameters.get(i));
                out.writeByte(32);
            }
            ByteBufUtil.writeUtf8((ByteBuf)out, (CharSequence)parameters.get(sizeMinusOne));
        } else {
            Iterator<CharSequence> params = parameters.iterator();
            while (true) {
                ByteBufUtil.writeUtf8((ByteBuf)out, (CharSequence)params.next());
                if (!params.hasNext()) break;
                out.writeByte(32);
            }
        }
    }
}

