/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import com.google.common.collect.Iterators;
import com.hubspot.smtp.messages.DotStuffing;
import com.hubspot.smtp.messages.MessageContent;
import com.hubspot.smtp.messages.MessageContentEncoding;
import com.hubspot.smtp.messages.MessageTermination;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.OptionalInt;

public class ByteBufMessageContent
extends MessageContent {
    private static final long LONG_WITH_HIGH_BITS_SET = -9187201950435737472L;
    private static final float UNCOUNTED = -1.0f;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final ByteBuf CR_LF_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])CR_LF));
    private final ByteBuf buffer;
    private final int size;
    private final MessageContentEncoding encoding;
    private float eightBitCharProportion = -1.0f;

    public ByteBufMessageContent(ByteBuf buffer, MessageContentEncoding encoding) {
        this.buffer = buffer;
        this.size = buffer.readableBytes();
        this.encoding = encoding;
    }

    @Override
    public Object getContent() {
        return ByteBufMessageContent.isTerminated(this.buffer) ? this.buffer : ByteBufMessageContent.terminate(this.buffer);
    }

    @Override
    public Iterator<ByteBuf> getContentChunkIterator(ByteBufAllocator allocator) {
        return Iterators.singletonIterator((Object)((ByteBuf)this.getContent()));
    }

    @Override
    public Object getDotStuffedContent() {
        return ByteBufMessageContent.dotStuff(this.buffer);
    }

    @Override
    public MessageContentEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public OptionalInt size() {
        return OptionalInt.of(this.size);
    }

    @Override
    public float get8bitCharacterProportion() {
        if (this.eightBitCharProportion != -1.0f) {
            return this.eightBitCharProportion;
        }
        int eightBitCharCount = 0;
        this.buffer.markReaderIndex();
        while (this.buffer.readableBytes() >= 8) {
            long bytes = this.buffer.readLong();
            if (0L == (bytes & 0x8080808080808080L)) continue;
            for (int i = 0; i < 8; ++i) {
                if (0L == (bytes & (long)(128 << i * 8))) continue;
                ++eightBitCharCount;
            }
        }
        while (this.buffer.readableBytes() > 0) {
            if (0 == (this.buffer.readByte() & 0x80)) continue;
            ++eightBitCharCount;
        }
        this.buffer.resetReaderIndex();
        this.eightBitCharProportion = 1.0f * (float)eightBitCharCount / (float)this.size;
        return this.eightBitCharProportion;
    }

    @Override
    public String getContentAsString() {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }

    private static ByteBuf terminate(ByteBuf buffer) {
        return buffer.alloc().compositeBuffer(2).addComponents(true, new ByteBuf[]{buffer, CR_LF_BUFFER.slice()});
    }

    private static boolean isTerminated(ByteBuf buffer) {
        int length = buffer.readableBytes();
        return length >= 2 && buffer.getByte(length - 2) == 13 && buffer.getByte(length - 1) == 10;
    }

    private static ByteBuf dotStuff(ByteBuf buffer) {
        return DotStuffing.createDotStuffedBuffer(buffer.alloc(), buffer, null, ByteBufMessageContent.isTerminated(buffer) ? MessageTermination.DO_NOT_TERMINATE : MessageTermination.ADD_CRLF);
    }
}

