/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;

class CrlfTerminatingChunkedStream
extends ChunkedStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int DEFAULT_CHUNK_SIZE = 65536;
    private static final byte[] TRAILING_BYTES = new byte[]{13, 10};

    CrlfTerminatingChunkedStream(InputStream in) {
        this(in, 65536);
    }

    CrlfTerminatingChunkedStream(InputStream in, int chunkSize) {
        super(in, chunkSize);
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf chunk = super.readChunk(allocator);
        if (!this.isEndOfInput()) {
            return chunk;
        }
        if (chunk == null || this.isTerminatedWithCrLf(chunk)) {
            return chunk;
        }
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{chunk, allocator.buffer(2).writeBytes(TRAILING_BYTES)});
    }

    private boolean isTerminatedWithCrLf(ByteBuf chunk) {
        int length = chunk.readableBytes();
        return length >= 2 && chunk.getByte(length - 2) == 13 && chunk.getByte(length - 1) == 10;
    }
}

