/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import com.hubspot.smtp.messages.MessageTermination;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;

final class DotStuffing {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DOT = 46;
    private static final byte[] DOT_DOT = new byte[]{46, 46};
    private static final byte[] NOT_CR_LF = new byte[]{120, 120};
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final ByteBuf DOT_DOT_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])DOT_DOT));
    private static final ByteBuf CR_LF_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])CR_LF));

    private DotStuffing() {
        throw new AssertionError((Object)"Cannot create static utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf createDotStuffedBuffer(ByteBufAllocator allocator, ByteBuf sourceBuffer, byte[] previousBytes, MessageTermination termination) {
        int dotIndex = DotStuffing.findDotAtBeginningOfLine(sourceBuffer, 0, DotStuffing.normalisePreviousBytes(previousBytes));
        try {
            int nextDotIndex;
            if (dotIndex == -1) {
                if (termination == MessageTermination.ADD_CRLF) {
                    CompositeByteBuf compositeByteBuf = allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{sourceBuffer.retainedSlice(), CR_LF_BUFFER.slice()});
                    return compositeByteBuf;
                }
                ByteBuf byteBuf = sourceBuffer.retainedSlice();
                return byteBuf;
            }
            CompositeByteBuf compositeByteBuf = allocator.compositeBuffer();
            compositeByteBuf.addComponents(true, new ByteBuf[]{sourceBuffer.retainedSlice(0, dotIndex), DOT_DOT_BUFFER.slice()});
            while ((nextDotIndex = DotStuffing.findDotAtBeginningOfLine(sourceBuffer, dotIndex + 1, NOT_CR_LF)) != -1) {
                compositeByteBuf.addComponents(true, new ByteBuf[]{sourceBuffer.retainedSlice(dotIndex + 1, nextDotIndex - dotIndex - 1), DOT_DOT_BUFFER.slice()});
                dotIndex = nextDotIndex;
            }
            compositeByteBuf.addComponent(true, sourceBuffer.retainedSlice(dotIndex + 1, sourceBuffer.readableBytes() - dotIndex - 1));
            if (termination == MessageTermination.ADD_CRLF) {
                compositeByteBuf.addComponent(true, CR_LF_BUFFER.slice());
            }
            CompositeByteBuf compositeByteBuf2 = compositeByteBuf;
            return compositeByteBuf2;
        }
        finally {
            sourceBuffer.release();
        }
    }

    private static byte[] normalisePreviousBytes(byte[] previousBytes) {
        if (previousBytes == null || previousBytes.length == 0) {
            return CR_LF;
        }
        if (previousBytes.length == 1) {
            return new byte[]{120, previousBytes[0]};
        }
        if (previousBytes.length > 2) {
            return new byte[]{previousBytes[previousBytes.length - 2], previousBytes[previousBytes.length - 1]};
        }
        return previousBytes;
    }

    private static int findDotAtBeginningOfLine(ByteBuf buffer, int startAt, byte[] previousBytes) {
        int length = buffer.readableBytes();
        if (previousBytes[0] == 13 && previousBytes[1] == 10 && buffer.getByte(startAt) == 46) {
            return startAt;
        }
        if (previousBytes[1] == 13 && length >= 2 && buffer.getByte(startAt) == 10 && buffer.getByte(startAt + 1) == 46) {
            return startAt + 1;
        }
        int i = startAt;
        while (++i < length) {
            if ((i = buffer.forEachByte(i, length - i, ByteProcessor.FIND_LF)) == -1) {
                return -1;
            }
            if (buffer.getByte(i - 1) != 13 || i + 1 >= length || buffer.getByte(i + 1) != 46) continue;
            return i + 1;
        }
        return -1;
    }
}

