/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import com.hubspot.smtp.messages.DotStuffing;
import com.hubspot.smtp.messages.MessageTermination;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;

class DotStuffingChunkedStream
extends ChunkedStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int DEFAULT_CHUNK_SIZE = 65536;
    private final byte[] trailingBytes = new byte[]{13, 10};

    DotStuffingChunkedStream(InputStream in) {
        this(in, 65536);
    }

    DotStuffingChunkedStream(InputStream in, int chunkSize) {
        super(in, chunkSize);
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf chunk = super.readChunk(allocator);
        if (chunk == null) {
            return null;
        }
        byte[] prevChunkTrailingBytes = new byte[]{this.trailingBytes[0], this.trailingBytes[1]};
        this.updateTrailingBytes(chunk);
        boolean appendCRLF = this.isEndOfInput() && (this.trailingBytes[0] != 13 || this.trailingBytes[1] != 10);
        return DotStuffing.createDotStuffedBuffer(allocator, chunk, prevChunkTrailingBytes, appendCRLF ? MessageTermination.ADD_CRLF : MessageTermination.DO_NOT_TERMINATE);
    }

    private void updateTrailingBytes(ByteBuf chunk) {
        if (chunk.readableBytes() == 0) {
            return;
        }
        if (chunk.readableBytes() == 1) {
            this.trailingBytes[0] = this.trailingBytes[1];
            this.trailingBytes[1] = chunk.getByte(0);
            return;
        }
        this.trailingBytes[0] = chunk.getByte(chunk.readableBytes() - 2);
        this.trailingBytes[1] = chunk.getByte(chunk.readableBytes() - 1);
    }
}

