/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import com.google.common.io.ByteSource;
import com.google.common.io.CharStreams;
import com.hubspot.smtp.messages.CrlfTerminatingChunkedStream;
import com.hubspot.smtp.messages.DotStuffingChunkedStream;
import com.hubspot.smtp.messages.MessageContent;
import com.hubspot.smtp.messages.MessageContentEncoding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.function.Supplier;

public class InputStreamMessageContent
extends MessageContent {
    private static final float UNCOUNTED = -1.0f;
    private static final float DEFAULT_8BIT_PROPORTION = 0.1f;
    private static final int READ_LIMIT = 8192;
    private final Supplier<InputStream> streamSupplier;
    private final OptionalInt size;
    private final MessageContentEncoding encoding;
    private float eightBitCharProportion = -1.0f;
    private InputStream stream;

    public InputStreamMessageContent(Supplier<InputStream> streamSupplier, OptionalInt size, MessageContentEncoding encoding) {
        this.streamSupplier = streamSupplier;
        this.size = size;
        this.encoding = encoding;
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public InputStreamMessageContent(ByteSource byteSource, OptionalInt size, MessageContentEncoding encoding) {
        this(InputStreamMessageContent.getStream(byteSource), size, encoding);
    }

    @Override
    public OptionalInt size() {
        return this.size;
    }

    @Override
    public Object getContent() {
        return new CrlfTerminatingChunkedStream(this.getStream());
    }

    @Override
    public Iterator<ByteBuf> getContentChunkIterator(final ByteBufAllocator allocator) {
        final CrlfTerminatingChunkedStream chunkedStream = new CrlfTerminatingChunkedStream(this.getStream());
        return new Iterator<ByteBuf>(){

            @Override
            public boolean hasNext() {
                try {
                    return !chunkedStream.isEndOfInput();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public ByteBuf next() {
                try {
                    return chunkedStream.readChunk(allocator);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public Object getDotStuffedContent() {
        return new DotStuffingChunkedStream(this.getStream());
    }

    @Override
    public MessageContentEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public float get8bitCharacterProportion() {
        if (this.eightBitCharProportion != -1.0f) {
            return this.eightBitCharProportion;
        }
        int eightBitCharCount = 0;
        InputStream inputStream = this.getStream();
        if (!inputStream.markSupported()) {
            this.eightBitCharProportion = 0.1f;
            return this.eightBitCharProportion;
        }
        inputStream.mark(8192);
        try {
            int c;
            int bytesRead;
            for (bytesRead = 0; bytesRead < 8192 && (c = inputStream.read()) != -1; ++bytesRead) {
                if (0 == (c & 0x80)) continue;
                ++eightBitCharCount;
            }
            inputStream.reset();
            this.eightBitCharProportion = 1.0f * (float)eightBitCharCount / (float)bytesRead;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.eightBitCharProportion;
    }

    @Override
    public String getContentAsString() {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(this.getStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getStream() {
        if (this.stream == null) {
            this.stream = this.streamSupplier.get();
        }
        return this.stream;
    }

    private static Supplier<InputStream> getStream(ByteSource byteSource) {
        return () -> {
            try {
                return byteSource.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open stream", e);
            }
        };
    }
}

