/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.smtp.messages;

import com.google.common.io.ByteSource;
import com.hubspot.smtp.messages.ByteBufMessageContent;
import com.hubspot.smtp.messages.InputStreamMessageContent;
import com.hubspot.smtp.messages.MessageContentEncoding;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.InputStream;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.function.Supplier;

public abstract class MessageContent {
    public static MessageContent of(ByteBuf messageBuffer) {
        return MessageContent.of(messageBuffer, MessageContentEncoding.UNKNOWN);
    }

    public static MessageContent of(ByteBuf messageBuffer, MessageContentEncoding encoding) {
        return new ByteBufMessageContent(messageBuffer, encoding);
    }

    public static MessageContent of(Supplier<InputStream> messageStream) {
        return MessageContent.of(messageStream, MessageContentEncoding.UNKNOWN);
    }

    public static MessageContent of(Supplier<InputStream> messageStream, MessageContentEncoding encoding) {
        return new InputStreamMessageContent(messageStream, OptionalInt.empty(), encoding);
    }

    public static MessageContent of(Supplier<InputStream> messageStream, MessageContentEncoding encoding, int size) {
        return new InputStreamMessageContent(messageStream, OptionalInt.of(size), encoding);
    }

    public static MessageContent of(ByteSource byteSource) {
        return MessageContent.of(byteSource, MessageContentEncoding.UNKNOWN);
    }

    public static MessageContent of(ByteSource byteSource, MessageContentEncoding encoding) {
        OptionalInt size = (OptionalInt)byteSource.sizeIfKnown().transform(s -> OptionalInt.of(Math.toIntExact(s))).or((Object)OptionalInt.empty());
        return new InputStreamMessageContent(byteSource, size, encoding);
    }

    public abstract OptionalInt size();

    MessageContent() {
    }

    public abstract Object getContent();

    public abstract Iterator<ByteBuf> getContentChunkIterator(ByteBufAllocator var1);

    public abstract Object getDotStuffedContent();

    public abstract MessageContentEncoding getEncoding();

    public abstract float get8bitCharacterProportion();

    public abstract String getContentAsString();
}

