/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.hubspot.horizon.HttpClient;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.horizon.ning.NingHttpClient;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.mesos.client.MesosClient;
import com.hubspot.mesos.client.SingularityMesosClient;
import com.hubspot.mesos.client.UserAndPassword;
import java.lang.annotation.Annotation;

public class SingularityMesosClientModule
extends AbstractModule {
    public static final String MESOS_CLIENT_OBJECT_MAPPER = "singularity.mesos.client.object.mapper";
    private static final int MESOS_CLIENT_HTTP_SHORT_TIMEOUT_SECONDS = 5;
    private final UserAndPassword credentials;

    public SingularityMesosClientModule(UserAndPassword credentials) {
        this.credentials = credentials;
    }

    public SingularityMesosClientModule() {
        this.credentials = UserAndPassword.empty();
    }

    protected void configure() {
        ObjectMapper objectMapper = JavaUtils.newObjectMapper();
        HttpConfig.Builder httpConfigBuilder = HttpConfig.newBuilder().setObjectMapper(objectMapper);
        this.bind(ObjectMapper.class).annotatedWith((Annotation)Names.named((String)MESOS_CLIENT_OBJECT_MAPPER)).toInstance((Object)objectMapper);
        this.bind(HttpClient.class).annotatedWith((Annotation)Names.named((String)"mesos.http.client")).toInstance((Object)new NingHttpClient(httpConfigBuilder.build()));
        this.bind(UserAndPassword.class).annotatedWith((Annotation)Names.named((String)"mesos.http.client.credentials")).toInstance((Object)this.credentials);
        this.bind(HttpClient.class).annotatedWith((Annotation)Names.named((String)"mesos.http.client.short.timeout")).toInstance((Object)new NingHttpClient(httpConfigBuilder.setRequestTimeoutSeconds(5).build()));
        this.bind(MesosClient.class).to(SingularityMesosClient.class).in(Scopes.SINGLETON);
    }
}

