/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.algebra.AbstractHttpResultWrapper;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class HttpResultWrapper<T, E>
extends AbstractHttpResultWrapper<T, E> {
    @Nullable
    private final T okResultMaybe;
    @Nullable
    private final E errResultMaybe;
    private final int httpStatusCode;

    private HttpResultWrapper(Builder<T, E> builder) {
        this.okResultMaybe = ((Builder)builder).okResultMaybe;
        this.errResultMaybe = ((Builder)builder).errResultMaybe;
        this.httpStatusCode = ((Builder)builder).httpStatusCodeIsSet() ? ((Builder)builder).httpStatusCode : super.getHttpStatusCode();
    }

    private HttpResultWrapper(@Nullable T okResultMaybe, @Nullable E errResultMaybe, int httpStatusCode) {
        this.okResultMaybe = okResultMaybe;
        this.errResultMaybe = errResultMaybe;
        this.httpStatusCode = httpStatusCode;
    }

    @Override
    @JsonProperty
    public Optional<T> getOkResultMaybe() {
        return Optional.ofNullable(this.okResultMaybe);
    }

    @Override
    @JsonProperty
    public Optional<E> getErrResultMaybe() {
        return Optional.ofNullable(this.errResultMaybe);
    }

    @Override
    @JsonProperty
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public final HttpResultWrapper<T, E> withOkResultMaybe(@Nullable T value) {
        T newValue = value;
        if (this.okResultMaybe == newValue) {
            return this;
        }
        return HttpResultWrapper.validate(new HttpResultWrapper<T, E>(newValue, this.errResultMaybe, this.httpStatusCode));
    }

    public final HttpResultWrapper<T, E> withOkResultMaybe(Optional<T> optional) {
        T value = optional.orElse(null);
        if (this.okResultMaybe == value) {
            return this;
        }
        return HttpResultWrapper.validate(new HttpResultWrapper<Object, E>(value, this.errResultMaybe, this.httpStatusCode));
    }

    public final HttpResultWrapper<T, E> withErrResultMaybe(@Nullable E value) {
        E newValue = value;
        if (this.errResultMaybe == newValue) {
            return this;
        }
        return HttpResultWrapper.validate(new HttpResultWrapper<T, E>(this.okResultMaybe, newValue, this.httpStatusCode));
    }

    public final HttpResultWrapper<T, E> withErrResultMaybe(Optional<E> optional) {
        E value = optional.orElse(null);
        if (this.errResultMaybe == value) {
            return this;
        }
        return HttpResultWrapper.validate(new HttpResultWrapper<T, Object>(this.okResultMaybe, value, this.httpStatusCode));
    }

    public final HttpResultWrapper<T, E> withHttpStatusCode(int httpStatusCode) {
        if (this.httpStatusCode == httpStatusCode) {
            return this;
        }
        return HttpResultWrapper.validate(new HttpResultWrapper<T, E>(this.okResultMaybe, this.errResultMaybe, httpStatusCode));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpResultWrapper && this.equalTo((HttpResultWrapper)another);
    }

    private boolean equalTo(HttpResultWrapper<?, ?> another) {
        return Objects.equals(this.okResultMaybe, another.okResultMaybe) && Objects.equals(this.errResultMaybe, another.errResultMaybe) && this.httpStatusCode == another.httpStatusCode;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.okResultMaybe);
        h = h * 17 + Objects.hashCode(this.errResultMaybe);
        h = h * 17 + this.httpStatusCode;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HttpResultWrapper{");
        if (this.okResultMaybe != null) {
            builder.append("okResultMaybe=").append(this.okResultMaybe);
        }
        if (this.errResultMaybe != null) {
            if (builder.length() > 18) {
                builder.append(", ");
            }
            builder.append("errResultMaybe=").append(this.errResultMaybe);
        }
        if (builder.length() > 18) {
            builder.append(", ");
        }
        builder.append("httpStatusCode=").append(this.httpStatusCode);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static <T, E> HttpResultWrapper<T, E> fromJson(Json<T, E> json) {
        Builder builder = HttpResultWrapper.builder();
        if (json.okResultMaybe != null) {
            builder.setOkResultMaybe(json.okResultMaybe);
        }
        if (json.errResultMaybe != null) {
            builder.setErrResultMaybe(json.errResultMaybe);
        }
        if (json.httpStatusCodeIsSet) {
            builder.setHttpStatusCode(json.httpStatusCode);
        }
        return builder.build();
    }

    private static <T, E> HttpResultWrapper<T, E> validate(HttpResultWrapper<T, E> instance) {
        instance.checkIsOkOrErr();
        return instance;
    }

    public static <T, E> HttpResultWrapper<T, E> copyOf(AbstractHttpResultWrapper<T, E> instance) {
        if (instance instanceof HttpResultWrapper) {
            return (HttpResultWrapper)instance;
        }
        return HttpResultWrapper.builder().from(instance).build();
    }

    public static <T, E> Builder<T, E> builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder<T, E> {
        private static final long OPT_BIT_HTTP_STATUS_CODE = 1L;
        private long optBits;
        @Nullable
        private T okResultMaybe;
        @Nullable
        private E errResultMaybe;
        private int httpStatusCode;

        private Builder() {
        }

        public final Builder<T, E> from(AbstractHttpResultWrapper<T, E> instance) {
            Optional<E> errResultMaybeOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<T> okResultMaybeOptional = instance.getOkResultMaybe();
            if (okResultMaybeOptional.isPresent()) {
                this.setOkResultMaybe(okResultMaybeOptional);
            }
            if ((errResultMaybeOptional = instance.getErrResultMaybe()).isPresent()) {
                this.setErrResultMaybe(errResultMaybeOptional);
            }
            this.setHttpStatusCode(instance.getHttpStatusCode());
            return this;
        }

        public final Builder<T, E> setOkResultMaybe(@Nullable T okResultMaybe) {
            this.okResultMaybe = okResultMaybe;
            return this;
        }

        public final Builder<T, E> setOkResultMaybe(Optional<T> okResultMaybe) {
            this.okResultMaybe = okResultMaybe.orElse(null);
            return this;
        }

        public final Builder<T, E> setErrResultMaybe(@Nullable E errResultMaybe) {
            this.errResultMaybe = errResultMaybe;
            return this;
        }

        public final Builder<T, E> setErrResultMaybe(Optional<E> errResultMaybe) {
            this.errResultMaybe = errResultMaybe.orElse(null);
            return this;
        }

        public final Builder<T, E> setHttpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            this.optBits |= 1L;
            return this;
        }

        public HttpResultWrapper<T, E> build() throws InvalidImmutableStateException {
            return HttpResultWrapper.validate(new HttpResultWrapper(this));
        }

        private boolean httpStatusCodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json<T, E>
    extends AbstractHttpResultWrapper<T, E> {
        Optional<T> okResultMaybe = Optional.empty();
        Optional<E> errResultMaybe = Optional.empty();
        int httpStatusCode;
        boolean httpStatusCodeIsSet;

        Json() {
        }

        @JsonProperty
        public void setOkResultMaybe(Optional<T> okResultMaybe) {
            this.okResultMaybe = okResultMaybe;
        }

        @JsonProperty
        public void setErrResultMaybe(Optional<E> errResultMaybe) {
            this.errResultMaybe = errResultMaybe;
        }

        @JsonProperty
        public void setHttpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            this.httpStatusCodeIsSet = true;
        }

        @Override
        public Optional<T> getOkResultMaybe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<E> getErrResultMaybe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHttpStatusCode() {
            throw new UnsupportedOperationException();
        }
    }
}

