package com.hubspot.algebra;

import java.lang.Object;
import java.lang.Override;
import java.lang.SuppressWarnings;
import java.lang.Void;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

final class VoidResults {
  private VoidResults() {
  }

  public static <ERROR_TYPE> VoidResult<ERROR_TYPE> err(ERROR_TYPE err) {
    return new Err<>(err);
  }

  public static <ERROR_TYPE> VoidResult<ERROR_TYPE> ok(Void ok) {
    return new Ok<>(ok);
  }

  public static <ERROR_TYPE> VoidResult<ERROR_TYPE> lazy(
      Supplier<VoidResult<ERROR_TYPE>> voidResult) {
    return new Lazy<>(voidResult);
  }

  @SuppressWarnings("unchecked")
  public static <ERROR_TYPE> CasesMatchers.TotalMatcher_Err<ERROR_TYPE> cases() {
    return (CasesMatchers.TotalMatcher_Err<ERROR_TYPE>) CasesMatchers.totalMatcher_Err;
  }

  public static <ERROR_TYPE> CaseOfMatchers.TotalMatcher_Err<ERROR_TYPE> caseOf(
      VoidResult<ERROR_TYPE> voidResult) {
    return new CaseOfMatchers.TotalMatcher_Err<ERROR_TYPE>(voidResult);
  }

  public static <ERROR_TYPE> Optional<ERROR_TYPE> getErr(VoidResult<ERROR_TYPE> voidResult) {
    return voidResult.match((err) -> Optional.of(err),
    (ok) -> Optional.empty());}

  public static <ERROR_TYPE> Optional<Void> getOk(VoidResult<ERROR_TYPE> voidResult) {
    return voidResult.match((err) -> Optional.empty(),
    (ok) -> Optional.of(ok));}

  public static <ERROR_TYPE, RERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<RERROR_TYPE>> setErr(
      RERROR_TYPE newErr) {
    return modErr(__ -> newErr);
  }

  public static <ERROR_TYPE, RERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<RERROR_TYPE>> modErr(
      Function<ERROR_TYPE, RERROR_TYPE> errMod) {
    return voidResult -> voidResult.match((err) -> err(errMod.apply(err)),
        VoidResults::ok);
  }

  public static <ERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<ERROR_TYPE>> setOk(
      Void newOk) {
    return modOk(__ -> newOk);
  }

  public static <ERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<ERROR_TYPE>> modOk(
      Function<Void, Void> okMod) {
    return voidResult -> voidResult.match(VoidResults::err,
        (ok) -> ok(okMod.apply(ok)));
  }

  private static final class Err<ERROR_TYPE> extends VoidResult<ERROR_TYPE> {
    private final ERROR_TYPE err;

    Err(ERROR_TYPE err) {
      this.err = err;
    }

    @Override
    public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
      return err.apply(this.err);
    }

    @Override
    @SuppressWarnings("unchecked")
    public boolean equals(Object obj) {
      return (obj instanceof VoidResult) && ((VoidResult<ERROR_TYPE>) obj).match((err) -> this.err.equals(err),
          (ok) -> false);
    }

    @Override
    public int hashCode() {
      return 23 + this.err.hashCode();
    }
  }

  private static final class Ok<ERROR_TYPE> extends VoidResult<ERROR_TYPE> {
    private final Void ok;

    Ok(Void ok) {
      this.ok = ok;
    }

    @Override
    public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
      return ok.apply(this.ok);
    }

    @Override
    @SuppressWarnings("unchecked")
    public boolean equals(Object obj) {
      return (obj instanceof VoidResult) && ((VoidResult<ERROR_TYPE>) obj).match((err) -> false,
          (ok) -> this.ok.equals(ok));
    }

    @Override
    public int hashCode() {
      return 29 + this.ok.hashCode();
    }
  }

  private static final class Lazy<ERROR_TYPE> extends VoidResult<ERROR_TYPE> {
    private volatile Supplier<VoidResult<ERROR_TYPE>> expression;

    private VoidResult<ERROR_TYPE> evaluation;

    Lazy(Supplier<VoidResult<ERROR_TYPE>> voidResult) {
      this.expression = voidResult;
    }

    private synchronized VoidResult<ERROR_TYPE> _evaluate() {
      Lazy<ERROR_TYPE> lazy = this;
      while (true) {
        Supplier<VoidResult<ERROR_TYPE>> expr = lazy.expression;
        if (expr == null) {
          evaluation = lazy.evaluation;
          break;
        }
        else {
          VoidResult<ERROR_TYPE> eval = expr.get();
          if (eval instanceof Lazy) {
            lazy = (Lazy<ERROR_TYPE>) eval;
          }
          else {
            evaluation = eval;
            break;
          }
        }
      }
      expression = null;
      return evaluation;
    }

    @Override
    public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
      return (this.expression == null ? this.evaluation : _evaluate()).match(err, ok);
    }

    @Override
    public boolean equals(Object obj) {
      return (this.expression == null ? this.evaluation : _evaluate()).equals(obj);
    }

    @Override
    public int hashCode() {
      return (this.expression == null ? this.evaluation : _evaluate()).hashCode();
    }
  }

  public static class CasesMatchers {
    private static final TotalMatcher_Err<?> totalMatcher_Err = new TotalMatcher_Err<>();

    private CasesMatchers() {
    }

    public static final class TotalMatcher_Err<ERROR_TYPE> {
      TotalMatcher_Err() {
      }

      public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err(Function<ERROR_TYPE, R> err) {
        return new TotalMatcher_Ok<>(err);
      }

      public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err_(R r) {
        return this.err((err) -> r);
      }

      public final <R> PartialMatcher<ERROR_TYPE, R> ok(Function<Void, R> ok) {
        return new PartialMatcher<>(null, ok);
      }

      public final <R> PartialMatcher<ERROR_TYPE, R> ok_(R r) {
        return this.ok((ok) -> r);
      }
    }

    public static final class TotalMatcher_Ok<ERROR_TYPE, R> extends PartialMatcher<ERROR_TYPE, R> {
      TotalMatcher_Ok(Function<ERROR_TYPE, R> err) {
        super(err, null);
      }

      public final Function<VoidResult<ERROR_TYPE>, R> ok(Function<Void, R> ok) {
        Function<ERROR_TYPE, R> err = super.err;
        return voidResult -> voidResult.match(err, ok);
      }

      public final Function<VoidResult<ERROR_TYPE>, R> ok_(R r) {
        return this.ok((ok) -> r);
      }
    }

    public static class PartialMatcher<ERROR_TYPE, R> {
      private final Function<ERROR_TYPE, R> err;

      private final Function<Void, R> ok;

      PartialMatcher(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
        this.err = err;
        this.ok = ok;
      }

      public final Function<VoidResult<ERROR_TYPE>, R> otherwise(Supplier<R> otherwise) {
        Function<ERROR_TYPE, R> err = (this.err != null) ? this.err : (err_) -> otherwise.get();
        Function<Void, R> ok = (this.ok != null) ? this.ok : (ok_) -> otherwise.get();
        return voidResult -> voidResult.match(err, ok);
      }

      public final Function<VoidResult<ERROR_TYPE>, R> otherwise_(R r) {
        return this.otherwise(() -> r);
      }

      public final Function<VoidResult<ERROR_TYPE>, Optional<R>> otherwiseEmpty() {
        Function<ERROR_TYPE, Optional<R>> err = (this.err != null) ? (err_) -> Optional.of(this.err.apply(err_))
            : (err_) -> Optional.empty();
        Function<Void, Optional<R>> ok = (this.ok != null) ? (ok_) -> Optional.of(this.ok.apply(ok_))
            : (ok_) -> Optional.empty();
        return voidResult -> voidResult.match(err, ok);
      }
    }
  }

  public static class CaseOfMatchers {
    private CaseOfMatchers() {
    }

    public static final class TotalMatcher_Err<ERROR_TYPE> {
      private final VoidResult<ERROR_TYPE> _voidResult;

      TotalMatcher_Err(VoidResult<ERROR_TYPE> _voidResult) {
        this._voidResult = _voidResult;
      }

      public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err(Function<ERROR_TYPE, R> err) {
        return new TotalMatcher_Ok<>(this._voidResult, err);
      }

      public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err_(R r) {
        return this.err((err) -> r);
      }

      public final <R> PartialMatcher<ERROR_TYPE, R> ok(Function<Void, R> ok) {
        return new PartialMatcher<>(this._voidResult, null, ok);
      }

      public final <R> PartialMatcher<ERROR_TYPE, R> ok_(R r) {
        return this.ok((ok) -> r);
      }
    }

    public static final class TotalMatcher_Ok<ERROR_TYPE, R> extends PartialMatcher<ERROR_TYPE, R> {
      TotalMatcher_Ok(VoidResult<ERROR_TYPE> _voidResult, Function<ERROR_TYPE, R> err) {
        super(_voidResult, err, null);
      }

      public final R ok(Function<Void, R> ok) {
        Function<ERROR_TYPE, R> err = super.err;
        return ((PartialMatcher<ERROR_TYPE, R>) this)._voidResult.match(err, ok);
      }

      public final R ok_(R r) {
        return this.ok((ok) -> r);
      }
    }

    public static class PartialMatcher<ERROR_TYPE, R> {
      private final VoidResult<ERROR_TYPE> _voidResult;

      private final Function<ERROR_TYPE, R> err;

      private final Function<Void, R> ok;

      PartialMatcher(VoidResult<ERROR_TYPE> _voidResult, Function<ERROR_TYPE, R> err,
          Function<Void, R> ok) {
        this._voidResult = _voidResult;
        this.err = err;
        this.ok = ok;
      }

      public final R otherwise(Supplier<R> otherwise) {
        Function<ERROR_TYPE, R> err = (this.err != null) ? this.err : (err_) -> otherwise.get();
        Function<Void, R> ok = (this.ok != null) ? this.ok : (ok_) -> otherwise.get();
        return this._voidResult.match(err, ok);
      }

      public final R otherwise_(R r) {
        return this.otherwise(() -> r);
      }

      public final Optional<R> otherwiseEmpty() {
        Function<ERROR_TYPE, Optional<R>> err = (this.err != null) ? (err_) -> Optional.of(this.err.apply(err_))
            : (err_) -> Optional.empty();
        Function<Void, Optional<R>> ok = (this.ok != null) ? (ok_) -> Optional.of(this.ok.apply(ok_))
            : (ok_) -> Optional.empty();
        return this._voidResult.match(err, ok);
      }
    }
  }
}
