/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.hubspot.algebra.NullValue;
import com.hubspot.algebra.Results;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.derive4j.Data;
import org.derive4j.Derive;
import org.derive4j.Visibility;

@Data(value=@Derive(withVisibility=Visibility.Package))
public abstract class Result<SUCCESS_TYPE, ERROR_TYPE> {
    public static <SUCCESS_TYPE, E> Result<SUCCESS_TYPE, E> ok(SUCCESS_TYPE success) {
        return Results.ok(success);
    }

    public static <T, ERROR_TYPE> Result<T, ERROR_TYPE> err(ERROR_TYPE error) {
        return Results.err(error);
    }

    public static <ERROR_TYPE> Result<NullValue, ERROR_TYPE> nullOk() {
        return Results.ok(NullValue.get());
    }

    public static <SUCCESS_TYPE> Result<SUCCESS_TYPE, NullValue> nullErr() {
        return Results.err(NullValue.get());
    }

    Result() {
    }

    public boolean isOk() {
        return Results.getOk(this).isPresent();
    }

    public void ifOk(Consumer<? super SUCCESS_TYPE> consumer) {
        Results.getOk(this).ifPresent(consumer);
    }

    public boolean isErr() {
        return Results.getErr(this).isPresent();
    }

    public void ifErr(Consumer<? super ERROR_TYPE> consumer) {
        Results.getErr(this).ifPresent(consumer);
    }

    public void consume(Consumer<? super ERROR_TYPE> errConsumer, Consumer<? super SUCCESS_TYPE> okConsumer) {
        this.ifOk(okConsumer);
        this.ifErr(errConsumer);
    }

    public <NEW_ERROR_TYPE> Result<SUCCESS_TYPE, NEW_ERROR_TYPE> mapErr(Function<ERROR_TYPE, NEW_ERROR_TYPE> mapper) {
        return Results.modErr(mapper).apply(this);
    }

    public <NEW_SUCCESS_TYPE> Result<NEW_SUCCESS_TYPE, ERROR_TYPE> mapOk(Function<SUCCESS_TYPE, NEW_SUCCESS_TYPE> mapper) {
        return Results.modOk(mapper).apply(this);
    }

    public <NEW_SUCCESS_TYPE> Result<NEW_SUCCESS_TYPE, ERROR_TYPE> flatMapOk(Function<SUCCESS_TYPE, Result<NEW_SUCCESS_TYPE, ERROR_TYPE>> mapper) {
        Result nestedResult = Results.modOk(mapper).apply(this);
        if (nestedResult.isErr()) {
            return Result.err(nestedResult.unwrapErrOrElseThrow());
        }
        return nestedResult.unwrapOrElseThrow();
    }

    public <NEW_ERROR_TYPE> Result<SUCCESS_TYPE, NEW_ERROR_TYPE> flatMapErr(Function<ERROR_TYPE, Result<SUCCESS_TYPE, NEW_ERROR_TYPE>> mapper) {
        Result nestedResult = Results.modErr(mapper).apply(this);
        if (nestedResult.isOk()) {
            return Result.ok(nestedResult.unwrapOrElseThrow());
        }
        return nestedResult.unwrapErrOrElseThrow();
    }

    public <X extends Throwable> SUCCESS_TYPE unwrapOrElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return Results.getOk(this).orElseThrow(exceptionSupplier);
    }

    public <X extends Throwable> SUCCESS_TYPE unwrapOrElseThrow(Function<ERROR_TYPE, ? extends X> exceptionMapper) throws X {
        return this.unwrapOrElseThrow(() -> (Throwable)exceptionMapper.apply(Results.getErr(this).get()));
    }

    public SUCCESS_TYPE unwrapOrElseThrow() {
        return this.unwrapOrElseThrow((ERROR_TYPE err) -> {
            if (err instanceof Throwable) {
                return new IllegalStateException((Throwable)err);
            }
            return new IllegalStateException(err.toString());
        });
    }

    public SUCCESS_TYPE expect(String message) {
        return this.unwrapOrElseThrow(() -> new IllegalStateException(message));
    }

    public <X extends Throwable> ERROR_TYPE unwrapErrOrElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return Results.getErr(this).orElseThrow(exceptionSupplier);
    }

    public <X extends Throwable> ERROR_TYPE unwrapErrOrElseThrow(Function<SUCCESS_TYPE, ? extends X> exceptionMapper) throws X {
        return this.unwrapErrOrElseThrow(() -> (Throwable)exceptionMapper.apply(Results.getOk(this).get()));
    }

    public ERROR_TYPE unwrapErrOrElseThrow() {
        return this.unwrapErrOrElseThrow((SUCCESS_TYPE ok) -> {
            if (ok instanceof Throwable) {
                return new IllegalStateException((Throwable)ok);
            }
            return new IllegalStateException(ok.toString());
        });
    }

    public ERROR_TYPE expectErr(String message) {
        return this.unwrapErrOrElseThrow(() -> new IllegalStateException(message));
    }

    public <NEW_SUCCESS_TYPE> Result<NEW_SUCCESS_TYPE, ERROR_TYPE> propagateErr() {
        if (this.isOk()) {
            throw new IllegalStateException("Cannot propagate an error for non-error Result");
        }
        Result res = this;
        return res;
    }

    public abstract <R> R match(Function<ERROR_TYPE, R> var1, Function<SUCCESS_TYPE, R> var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        if (this.isOk()) {
            return "Ok[" + this.unwrapOrElseThrow().toString() + "]";
        }
        return "Err[" + this.unwrapErrOrElseThrow().toString() + "]";
    }
}

