/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.hubspot.algebra.VoidResult;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

final class VoidResults {
    private VoidResults() {
    }

    public static <ERROR_TYPE> VoidResult<ERROR_TYPE> err(ERROR_TYPE err) {
        return new Err<ERROR_TYPE>(err);
    }

    public static <ERROR_TYPE> VoidResult<ERROR_TYPE> ok(Void ok) {
        return new Ok(ok);
    }

    public static <ERROR_TYPE> VoidResult<ERROR_TYPE> lazy(Supplier<VoidResult<ERROR_TYPE>> voidResult) {
        return new Lazy<ERROR_TYPE>(voidResult);
    }

    public static <ERROR_TYPE> CasesMatchers.TotalMatcher_Err<ERROR_TYPE> cases() {
        return CasesMatchers.totalMatcher_Err;
    }

    public static <ERROR_TYPE> CaseOfMatchers.TotalMatcher_Err<ERROR_TYPE> caseOf(VoidResult<ERROR_TYPE> voidResult) {
        return new CaseOfMatchers.TotalMatcher_Err<ERROR_TYPE>(voidResult);
    }

    public static <ERROR_TYPE> Optional<ERROR_TYPE> getErr(VoidResult<ERROR_TYPE> voidResult) {
        return voidResult.match(err -> Optional.of(err), ok -> Optional.empty());
    }

    public static <ERROR_TYPE> Optional<Void> getOk(VoidResult<ERROR_TYPE> voidResult) {
        return voidResult.match(err -> Optional.empty(), ok -> Optional.of(ok));
    }

    public static <ERROR_TYPE, RERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<RERROR_TYPE>> setErr(RERROR_TYPE newErr) {
        return VoidResults.modErr(__ -> newErr);
    }

    public static <ERROR_TYPE, RERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<RERROR_TYPE>> modErr(Function<ERROR_TYPE, RERROR_TYPE> errMod) {
        return voidResult -> voidResult.match(err -> VoidResults.err(errMod.apply(err)), VoidResults::ok);
    }

    public static <ERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<ERROR_TYPE>> setOk(Void newOk) {
        return VoidResults.modOk(__ -> newOk);
    }

    public static <ERROR_TYPE> Function<VoidResult<ERROR_TYPE>, VoidResult<ERROR_TYPE>> modOk(Function<Void, Void> okMod) {
        return voidResult -> voidResult.match(VoidResults::err, ok -> VoidResults.ok((Void)okMod.apply((Void)ok)));
    }

    private static final class Err<ERROR_TYPE>
    extends VoidResult<ERROR_TYPE> {
        private final ERROR_TYPE err;

        Err(ERROR_TYPE err) {
            this.err = err;
        }

        @Override
        public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
            return err.apply(this.err);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VoidResult && ((VoidResult)obj).match((ERROR_TYPE err) -> this.err.equals(err), (Void ok) -> false) != false;
        }

        @Override
        public int hashCode() {
            return 23 + this.err.hashCode();
        }
    }

    private static final class Ok<ERROR_TYPE>
    extends VoidResult<ERROR_TYPE> {
        private final Void ok;

        Ok(Void ok) {
            this.ok = ok;
        }

        @Override
        public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
            return ok.apply(this.ok);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VoidResult && ((VoidResult)obj).match((ERROR_TYPE err) -> false, (Void ok) -> this.ok.equals(ok)) != false;
        }

        @Override
        public int hashCode() {
            return 29 + this.ok.hashCode();
        }
    }

    private static final class Lazy<ERROR_TYPE>
    extends VoidResult<ERROR_TYPE> {
        private volatile Supplier<VoidResult<ERROR_TYPE>> expression;
        private VoidResult<ERROR_TYPE> evaluation;

        Lazy(Supplier<VoidResult<ERROR_TYPE>> voidResult) {
            this.expression = voidResult;
        }

        private synchronized VoidResult<ERROR_TYPE> _evaluate() {
            block2: {
                VoidResult<ERROR_TYPE> eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<VoidResult<ERROR_TYPE>> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(err, ok);
        }

        @Override
        public boolean equals(Object obj) {
            return (this.expression == null ? this.evaluation : this._evaluate()).equals(obj);
        }

        @Override
        public int hashCode() {
            return (this.expression == null ? this.evaluation : this._evaluate()).hashCode();
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_Err<?> totalMatcher_Err = new TotalMatcher_Err();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_Err<ERROR_TYPE> {
            TotalMatcher_Err() {
            }

            public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err(Function<ERROR_TYPE, R> err) {
                return new TotalMatcher_Ok<ERROR_TYPE, R>(err);
            }

            public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err_(R r) {
                return this.err(err -> r);
            }

            public final <R> PartialMatcher<ERROR_TYPE, R> ok(Function<Void, R> ok) {
                return new PartialMatcher(null, ok);
            }

            public final <R> PartialMatcher<ERROR_TYPE, R> ok_(R r) {
                return this.ok(ok -> r);
            }
        }

        public static class PartialMatcher<ERROR_TYPE, R> {
            private final Function<ERROR_TYPE, R> err;
            private final Function<Void, R> ok;

            PartialMatcher(Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
                this.err = err;
                this.ok = ok;
            }

            public final Function<VoidResult<ERROR_TYPE>, R> otherwise(Supplier<R> otherwise) {
                Function<Object, Object> err = this.err != null ? this.err : err_ -> otherwise.get();
                Function<Void, Object> ok = this.ok != null ? this.ok : ok_ -> otherwise.get();
                return voidResult -> voidResult.match(err, ok);
            }

            public final Function<VoidResult<ERROR_TYPE>, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<VoidResult<ERROR_TYPE>, Optional<R>> otherwiseEmpty() {
                Function<Object, Optional> err = this.err != null ? err_ -> Optional.of(this.err.apply(err_)) : err_ -> Optional.empty();
                Function<Void, Optional> ok = this.ok != null ? ok_ -> Optional.of(this.ok.apply((Void)ok_)) : ok_ -> Optional.empty();
                return voidResult -> (Optional)voidResult.match(err, ok);
            }
        }

        public static final class TotalMatcher_Ok<ERROR_TYPE, R>
        extends PartialMatcher<ERROR_TYPE, R> {
            TotalMatcher_Ok(Function<ERROR_TYPE, R> err) {
                super(err, null);
            }

            public final Function<VoidResult<ERROR_TYPE>, R> ok(Function<Void, R> ok) {
                Function err = this.err;
                return voidResult -> voidResult.match(err, ok);
            }

            public final Function<VoidResult<ERROR_TYPE>, R> ok_(R r) {
                return this.ok(ok -> r);
            }
        }
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<ERROR_TYPE, R> {
            private final VoidResult<ERROR_TYPE> _voidResult;
            private final Function<ERROR_TYPE, R> err;
            private final Function<Void, R> ok;

            PartialMatcher(VoidResult<ERROR_TYPE> _voidResult, Function<ERROR_TYPE, R> err, Function<Void, R> ok) {
                this._voidResult = _voidResult;
                this.err = err;
                this.ok = ok;
            }

            public final R otherwise(Supplier<R> otherwise) {
                Function<Object, Object> err = this.err != null ? this.err : err_ -> otherwise.get();
                Function<Void, Object> ok = this.ok != null ? this.ok : ok_ -> otherwise.get();
                return this._voidResult.match(err, ok);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                Function<Object, Optional> err = this.err != null ? err_ -> Optional.of(this.err.apply(err_)) : err_ -> Optional.empty();
                Function<Void, Optional> ok = this.ok != null ? ok_ -> Optional.of(this.ok.apply((Void)ok_)) : ok_ -> Optional.empty();
                return this._voidResult.match(err, ok);
            }
        }

        public static final class TotalMatcher_Ok<ERROR_TYPE, R>
        extends PartialMatcher<ERROR_TYPE, R> {
            TotalMatcher_Ok(VoidResult<ERROR_TYPE> _voidResult, Function<ERROR_TYPE, R> err) {
                super(_voidResult, err, null);
            }

            public final R ok(Function<Void, R> ok) {
                Function err = this.err;
                return this._voidResult.match(err, ok);
            }

            public final R ok_(R r) {
                return (R)this.ok(ok -> r);
            }
        }

        public static final class TotalMatcher_Err<ERROR_TYPE> {
            private final VoidResult<ERROR_TYPE> _voidResult;

            TotalMatcher_Err(VoidResult<ERROR_TYPE> _voidResult) {
                this._voidResult = _voidResult;
            }

            public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err(Function<ERROR_TYPE, R> err) {
                return new TotalMatcher_Ok<ERROR_TYPE, R>(this._voidResult, err);
            }

            public final <R> TotalMatcher_Ok<ERROR_TYPE, R> err_(R r) {
                return this.err(err -> r);
            }

            public final <R> PartialMatcher<ERROR_TYPE, R> ok(Function<Void, R> ok) {
                return new PartialMatcher<ERROR_TYPE, R>(this._voidResult, null, ok);
            }

            public final <R> PartialMatcher<ERROR_TYPE, R> ok_(R r) {
                return this.ok(ok -> r);
            }
        }
    }
}

