/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.util.Modules;
import com.hubspot.dropwizard.guice.AutoConfig;
import com.hubspot.dropwizard.guice.GuiceContainer;
import com.hubspot.dropwizard.guice.JerseyContainerModule;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    final Logger logger = LoggerFactory.getLogger(GuiceBundle.class);
    private final AutoConfig autoConfig;
    private final List<Module> modules;

    public static <T extends Configuration> Builder<T> newBuilder() {
        return new Builder();
    }

    private GuiceBundle(AutoConfig autoConfig, List<Module> modules) {
        Preconditions.checkNotNull(modules);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
        this.modules = modules;
        this.autoConfig = autoConfig;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(final Configuration configuration, final Environment environment) {
        GuiceContainer container = new GuiceContainer(){

            @Override
            protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
                return environment.getJerseyResourceConfig();
            }
        };
        environment.setJerseyServletContainer((ServletContainer)container);
        environment.addFilter(GuiceFilter.class, configuration.getHttpConfiguration().getRootPath());
        this.modules.add(Modules.override((Module[])new Module[]{new JerseyServletModule()}).with(new Module[]{new JerseyContainerModule(container)}));
        this.modules.add((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Configuration.class).toInstance((Object)configuration);
                this.bind(Environment.class).toInstance((Object)environment);
            }
        });
        Injector injector = Guice.createInjector(this.modules);
        if (this.autoConfig != null) {
            this.autoConfig.run(environment, injector);
        }
    }

    /* synthetic */ GuiceBundle(AutoConfig autoConfig, List list, GuiceBundle guiceBundle) {
        this(autoConfig, list);
    }

    public static class Builder<T extends Configuration> {
        private AutoConfig autoConfig;
        private List<Module> modules = Lists.newArrayList();

        public Builder<T> addModule(Module module) {
            Preconditions.checkNotNull((Object)module);
            this.modules.add(module);
            return this;
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkNotNull((Object)(basePackages.length > 0 ? 1 : 0));
            Preconditions.checkArgument((this.autoConfig == null ? 1 : 0) != 0, (Object)"autoConfig already enabled!");
            this.autoConfig = new AutoConfig(basePackages);
            return this;
        }

        public GuiceBundle<T> build() {
            return new GuiceBundle(this.autoConfig, this.modules, null);
        }
    }
}

