/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.spi.Message;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import java.util.Arrays;

public class DropwizardEnvironmentModule<T extends Configuration>
extends AbstractModule {
    private T configuration;
    private Environment environment;
    private Class<? super T> configurationClass;

    public DropwizardEnvironmentModule(Class<T> configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected void configure() {
        CustomConfigurationProvider provider = new CustomConfigurationProvider();
        this.bind(this.configurationClass).toProvider((Provider)provider);
        if (this.configurationClass != Configuration.class) {
            this.bind(Configuration.class).toProvider((Provider)provider);
        }
    }

    public void setEnvironmentData(T configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
    }

    @Provides
    public Environment providesEnvironment() {
        if (this.environment == null) {
            throw new CreationException(Arrays.asList(new Message("The dropwizard environment has not yet been set. This is likely caused by trying to access the dropwizard environment during the bootstrap phase.")));
        }
        return this.environment;
    }

    private class CustomConfigurationProvider
    implements Provider<T> {
        private CustomConfigurationProvider() {
        }

        public T get() {
            if (DropwizardEnvironmentModule.this.configuration == null) {
                throw new CreationException(Arrays.asList(new Message("The dropwizard configuration has not yet been set. This is likely caused by trying to access the dropwizard environment during the bootstrap phase.")));
            }
            return DropwizardEnvironmentModule.this.configuration;
        }
    }
}

