/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.util.Modules;
import com.hubspot.dropwizard.guice.AutoConfig;
import com.hubspot.dropwizard.guice.DropwizardEnvironmentModule;
import com.hubspot.dropwizard.guice.GuiceContainer;
import com.hubspot.dropwizard.guice.JerseyContainerModule;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    final Logger logger = LoggerFactory.getLogger(GuiceBundle.class);
    private final AutoConfig autoConfig;
    private final List<Module> modules;
    private Injector injector;
    private JerseyContainerModule jerseyContainerModule;
    private DropwizardEnvironmentModule dropwizardEnvironmentModule;
    private Optional<Class<T>> configurationClass;
    private GuiceContainer container;

    public static <T extends Configuration> Builder<T> newBuilder() {
        return new Builder();
    }

    private GuiceBundle(AutoConfig autoConfig, List<Module> modules, Optional<Class<T>> configurationClass) {
        Preconditions.checkNotNull(modules);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
        this.modules = modules;
        this.autoConfig = autoConfig;
        this.configurationClass = configurationClass;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.container = new GuiceContainer();
        this.jerseyContainerModule = new JerseyContainerModule(this.container);
        this.dropwizardEnvironmentModule = this.configurationClass.isPresent() ? new DropwizardEnvironmentModule((Class)this.configurationClass.get()) : new DropwizardEnvironmentModule<Configuration>(Configuration.class);
        this.modules.add(Modules.override((Module[])new Module[]{new JerseyServletModule()}).with(new Module[]{this.jerseyContainerModule}));
        this.modules.add((Module)this.dropwizardEnvironmentModule);
        this.injector = Guice.createInjector(this.modules);
        if (this.autoConfig != null) {
            this.autoConfig.initialize(bootstrap, this.injector);
        }
    }

    public void run(T configuration, Environment environment) {
        this.container.setResourceConfig(environment.getJerseyResourceConfig());
        environment.setJerseyServletContainer((ServletContainer)this.container);
        environment.addFilter(GuiceFilter.class, configuration.getHttpConfiguration().getRootPath());
        this.setEnvironment(configuration, environment);
        if (this.autoConfig != null) {
            this.autoConfig.run(environment, this.injector);
        }
    }

    private void setEnvironment(T configuration, Environment environment) {
        this.dropwizardEnvironmentModule.setEnvironmentData(configuration, environment);
    }

    public Injector getInjector() {
        return this.injector;
    }

    /* synthetic */ GuiceBundle(AutoConfig autoConfig, List list, Optional optional, GuiceBundle guiceBundle) {
        this(autoConfig, list, optional);
    }

    public static class Builder<T extends Configuration> {
        private AutoConfig autoConfig;
        private List<Module> modules = Lists.newArrayList();
        private Optional<Class<T>> configurationClass;

        public Builder<T> addModule(Module module) {
            Preconditions.checkNotNull((Object)module);
            this.modules.add(module);
            return this;
        }

        public Builder<T> setConfigClass(Class<T> clazz) {
            this.configurationClass = Optional.of(clazz);
            return this;
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkNotNull((Object)(basePackages.length > 0 ? 1 : 0));
            Preconditions.checkArgument((this.autoConfig == null ? 1 : 0) != 0, (Object)"autoConfig already enabled!");
            this.autoConfig = new AutoConfig(basePackages);
            return this;
        }

        public GuiceBundle<T> build() {
            return new GuiceBundle(this.autoConfig, this.modules, this.configurationClass, null);
        }
    }
}

