/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Injector;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.yammer.dropwizard.Bundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.dropwizard.tasks.Task;
import com.yammer.metrics.core.HealthCheck;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfig {
    final Logger logger = LoggerFactory.getLogger(AutoConfig.class);
    private Reflections reflections;

    public AutoConfig(String ... basePackages) {
        Preconditions.checkArgument((basePackages.length > 0 ? 1 : 0) != 0);
        ConfigurationBuilder cfgBldr = new ConfigurationBuilder();
        FilterBuilder filterBuilder = new FilterBuilder();
        for (String basePkg : basePackages) {
            cfgBldr.addUrls(ClasspathHelper.forPackage((String)basePkg, (ClassLoader[])new ClassLoader[0]));
            filterBuilder.include(FilterBuilder.prefix((String)basePkg));
        }
        cfgBldr.filterInputsBy((Predicate)filterBuilder).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        this.reflections = new Reflections((Configuration)cfgBldr);
    }

    public void run(Environment environment, Injector injector) {
        this.addHealthChecks(environment, injector);
        this.addProviders(environment, injector);
        this.addInjectableProviders(environment, injector);
        this.addResources(environment, injector);
        this.addTasks(environment, injector);
        this.addManaged(environment, injector);
    }

    public void initialize(Bootstrap<?> bootstrap, Injector injector) {
        this.addBundles(bootstrap, injector);
    }

    private void addManaged(Environment environment, Injector injector) {
        Set managedClasses = this.reflections.getSubTypesOf(Managed.class);
        for (Class managed : managedClasses) {
            environment.manage((Managed)injector.getInstance(managed));
            this.logger.info("Added managed: " + managed);
        }
    }

    private void addTasks(Environment environment, Injector injector) {
        Set taskClasses = this.reflections.getSubTypesOf(Task.class);
        for (Class task : taskClasses) {
            environment.addTask((Task)injector.getInstance(task));
            this.logger.info("Added task: " + task);
        }
    }

    private void addHealthChecks(Environment environment, Injector injector) {
        Set healthCheckClasses = this.reflections.getSubTypesOf(HealthCheck.class);
        for (Class healthCheck : healthCheckClasses) {
            environment.addHealthCheck((HealthCheck)injector.getInstance(healthCheck));
            this.logger.info("Added healthCheck: " + healthCheck);
        }
    }

    private void addInjectableProviders(Environment environment, Injector injector) {
        Set injectableProviders = this.reflections.getSubTypesOf(InjectableProvider.class);
        for (Class injectableProvider : injectableProviders) {
            environment.addProvider(injectableProvider);
            this.logger.info("Added injectableProvider: " + injectableProvider);
        }
    }

    private void addProviders(Environment environment, Injector injector) {
        Set providerClasses = this.reflections.getTypesAnnotatedWith(Provider.class);
        for (Class provider : providerClasses) {
            environment.addProvider(provider);
            this.logger.info("Added provider class: " + provider);
        }
    }

    private void addResources(Environment environment, Injector injector) {
        Set resourceClasses = this.reflections.getTypesAnnotatedWith(Path.class);
        for (Class resource : resourceClasses) {
            environment.addResource(resource);
            this.logger.info("Added resource class: " + resource);
        }
    }

    private void addBundles(Bootstrap<?> bootstrap, Injector injector) {
        Set bundleClasses = this.reflections.getSubTypesOf(Bundle.class);
        for (Class bundle : bundleClasses) {
            bootstrap.addBundle((Bundle)injector.getInstance(bundle));
            this.logger.info(String.format("Added bundle class %s during bootstrap", bundle));
        }
    }
}

