/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;

public class DropwizardEnvironmentModule<T extends Configuration>
extends AbstractModule {
    private static final String ILLEGAL_DROPWIZARD_MODULE_STATE = "The dropwizard environment has not yet been set. This is likely caused by trying to access the dropwizard environment during the bootstrap phase.";
    private T configuration;
    private Environment environment;
    private Class<? super T> configurationClass;

    public DropwizardEnvironmentModule(Class<T> configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected void configure() {
        CustomConfigurationProvider provider = new CustomConfigurationProvider();
        this.bind(this.configurationClass).toProvider((Provider)provider);
        if (this.configurationClass != Configuration.class) {
            this.bind(Configuration.class).toProvider((Provider)provider);
        }
    }

    public void setEnvironmentData(T configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
    }

    @Provides
    public Environment providesEnvironment() {
        if (this.environment == null) {
            throw new ProvisionException(ILLEGAL_DROPWIZARD_MODULE_STATE);
        }
        return this.environment;
    }

    private class CustomConfigurationProvider
    implements Provider<T> {
        private CustomConfigurationProvider() {
        }

        public T get() {
            if (DropwizardEnvironmentModule.this.configuration == null) {
                throw new ProvisionException(DropwizardEnvironmentModule.ILLEGAL_DROPWIZARD_MODULE_STATE);
            }
            return DropwizardEnvironmentModule.this.configuration;
        }
    }
}

