/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.hubspot.dropwizard.guice.GuiceBundle;
import com.hubspot.dropwizard.guice.InjectableHealthCheck;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.Resource;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfig {
    private static final Logger logger = LoggerFactory.getLogger(AutoConfig.class);
    private final Reflections reflections;

    public AutoConfig(String ... basePackages) {
        Preconditions.checkArgument((basePackages.length > 0 ? 1 : 0) != 0);
        ConfigurationBuilder cfgBldr = new ConfigurationBuilder();
        FilterBuilder filterBuilder = new FilterBuilder();
        for (String basePkg : basePackages) {
            cfgBldr.addUrls(ClasspathHelper.forPackage((String)basePkg, (ClassLoader[])new ClassLoader[0]));
            filterBuilder.include(FilterBuilder.prefix((String)basePkg));
        }
        cfgBldr.filterInputsBy((Predicate)filterBuilder).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        this.reflections = new Reflections((Configuration)cfgBldr);
    }

    public void run(Environment environment, Injector injector) {
        this.addHealthChecks(environment, injector);
        this.addProviders(environment);
        this.addResources(environment);
        this.addTasks(environment, injector);
        this.addManaged(environment, injector);
        this.addParamConverterProviders(environment);
    }

    public void initialize(Bootstrap<?> bootstrap, Injector injector) {
        this.addBundles(bootstrap, injector);
        this.addConfiguredBundles(bootstrap, injector);
    }

    private void addManaged(Environment environment, Injector injector) {
        Set managedClasses = this.reflections.getSubTypesOf(Managed.class);
        for (Class managed : managedClasses) {
            Optional maybeManaged = this.getFromGuiceIfPossible(injector, managed);
            if (!maybeManaged.isPresent()) continue;
            environment.lifecycle().manage((Managed)maybeManaged.get());
            logger.info("Added managed: {}", (Object)managed);
        }
    }

    private void addTasks(Environment environment, Injector injector) {
        Set taskClasses = this.reflections.getSubTypesOf(Task.class);
        for (Class task : taskClasses) {
            Optional maybeTask = this.getFromGuiceIfPossible(injector, task);
            if (!maybeTask.isPresent()) continue;
            environment.admin().addTask((Task)maybeTask.get());
            logger.info("Added task: {}", (Object)task);
        }
    }

    private void addHealthChecks(Environment environment, Injector injector) {
        Set healthCheckClasses = this.reflections.getSubTypesOf(InjectableHealthCheck.class);
        for (Class healthCheck : healthCheckClasses) {
            Optional maybeHealthCheck = this.getFromGuiceIfPossible(injector, healthCheck);
            if (!maybeHealthCheck.isPresent()) continue;
            environment.healthChecks().register(((InjectableHealthCheck)((Object)maybeHealthCheck.get())).getName(), (HealthCheck)maybeHealthCheck.get());
            logger.info("Added injectableHealthCheck: {}", (Object)healthCheck);
        }
    }

    private void addProviders(Environment environment) {
        Set providerClasses = this.reflections.getTypesAnnotatedWith(Provider.class);
        for (Class provider : providerClasses) {
            environment.jersey().register(provider);
            logger.info("Added provider class: {}", (Object)provider);
        }
    }

    private void addResources(Environment environment) {
        Set resourceClasses = this.reflections.getTypesAnnotatedWith(Path.class);
        for (Class resource : resourceClasses) {
            if (!Resource.isAcceptable((Class)resource)) continue;
            environment.jersey().register(resource);
            logger.info("Added resource class: {}", (Object)resource);
        }
    }

    private void addBundles(Bootstrap<?> bootstrap, Injector injector) {
        Set bundleClasses = this.reflections.getSubTypesOf(Bundle.class);
        for (Class bundle : bundleClasses) {
            Optional maybeBundle = this.getFromGuiceIfPossible(injector, bundle);
            if (!maybeBundle.isPresent()) continue;
            bootstrap.addBundle((Bundle)maybeBundle.get());
            logger.info("Added bundle class {} during bootstrap", (Object)bundle);
        }
    }

    private void addConfiguredBundles(Bootstrap<?> bootstrap, Injector injector) {
        Set configuredBundleClasses = this.reflections.getSubTypesOf(ConfiguredBundle.class);
        for (Class configuredBundle : configuredBundleClasses) {
            Optional maybeConfiguredBundle;
            if (configuredBundle == GuiceBundle.class || !(maybeConfiguredBundle = this.getFromGuiceIfPossible(injector, configuredBundle)).isPresent()) continue;
            bootstrap.addBundle((ConfiguredBundle)maybeConfiguredBundle.get());
            logger.info("Added configured bundle class {} during bootstrap", (Object)configuredBundle);
        }
    }

    private void addParamConverterProviders(Environment environment) {
        Set providerClasses = this.reflections.getSubTypesOf(ParamConverterProvider.class);
        for (Class provider : providerClasses) {
            environment.jersey().register(provider);
            logger.info("Added ParamConverterProvider class: {}", (Object)provider);
        }
    }

    private <T> Optional<T> getFromGuiceIfPossible(Injector injector, Class<T> type) {
        if (AutoConfig.concreteClass(type) || AutoConfig.hasBinding(injector, type)) {
            return Optional.of((Object)injector.getInstance(type));
        }
        logger.info("Not attempting to retrieve abstract class {} from injector", type);
        return Optional.absent();
    }

    private static boolean concreteClass(Class<?> type) {
        return !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    private static boolean hasBinding(Injector injector, Class<?> type) {
        return injector.getExistingBinding(Key.get(type)) != null || AutoConfig.hasBindingAnnotation(type);
    }

    private static boolean hasBindingAnnotation(Class<?> type) {
        return type.isAnnotationPresent(ImplementedBy.class) || type.isAnnotationPresent(ProvidedBy.class);
    }
}

