/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.hubspot.dropwizard.guice.AutoConfig;
import com.hubspot.dropwizard.guice.DropwizardEnvironmentModule;
import com.hubspot.dropwizard.guice.InjectorFactory;
import com.hubspot.dropwizard.guice.InjectorFactoryImpl;
import com.hubspot.dropwizard.guice.JerseyUtil;
import com.squarespace.jersey2.guice.JerseyGuiceModule;
import com.squarespace.jersey2.guice.JerseyGuiceUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EventListener;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    final Logger logger = LoggerFactory.getLogger(GuiceBundle.class);
    private final AutoConfig autoConfig;
    private final List<Module> modules;
    private final InjectorFactory injectorFactory;
    private Injector baseInjector;
    private DropwizardEnvironmentModule dropwizardEnvironmentModule;
    private Optional<Class<T>> configurationClass;
    private Stage stage;

    public static <T extends Configuration> Builder<T> newBuilder() {
        return new Builder();
    }

    private GuiceBundle(Stage stage, AutoConfig autoConfig, List<Module> modules, Optional<Class<T>> configurationClass, InjectorFactory injectorFactory) {
        Preconditions.checkNotNull(modules);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)stage);
        this.modules = modules;
        this.autoConfig = autoConfig;
        this.configurationClass = configurationClass;
        this.injectorFactory = injectorFactory;
        this.stage = stage;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.dropwizardEnvironmentModule = this.configurationClass.isPresent() ? new DropwizardEnvironmentModule((Class)this.configurationClass.get()) : new DropwizardEnvironmentModule<Configuration>(Configuration.class);
        this.modules.add((Module)this.dropwizardEnvironmentModule);
        this.modules.add((Module)new ServletModule());
        this.initInjector();
        JerseyGuiceUtils.install((ServiceLocatorGenerator)new ServiceLocatorGenerator(){

            public ServiceLocator create(String name, ServiceLocator parent) {
                if (!name.startsWith("__HK2_Generated_")) {
                    return null;
                }
                return (ServiceLocator)GuiceBundle.this.baseInjector.createChildInjector(new Module[]{new JerseyGuiceModule(name)}).getInstance(ServiceLocator.class);
            }
        });
        if (this.autoConfig != null) {
            this.autoConfig.initialize(bootstrap, this.baseInjector.createChildInjector(new Module[]{new JerseyGuiceModule(JerseyGuiceUtils.newServiceLocator())}));
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private void initInjector() {
        try {
            this.baseInjector = this.injectorFactory.create(this.stage, (List<Module>)ImmutableList.copyOf(this.modules));
        }
        catch (Exception ie) {
            this.logger.error("Exception occurred when creating Guice Injector - exiting", (Throwable)ie);
            System.exit(1);
        }
    }

    public void run(T configuration, Environment environment) {
        JerseyUtil.registerGuiceBound(this.baseInjector, environment.jersey());
        JerseyUtil.registerGuiceFilter(environment);
        environment.servlets().addServletListeners(new EventListener[]{new GuiceServletContextListener(){

            protected Injector getInjector() {
                return GuiceBundle.this.baseInjector;
            }
        }});
        this.setEnvironment(configuration, environment);
        if (this.autoConfig != null) {
            this.autoConfig.run(environment, this.baseInjector);
        }
    }

    private void setEnvironment(T configuration, Environment environment) {
        this.dropwizardEnvironmentModule.setEnvironmentData(configuration, environment);
    }

    public Injector getInjector() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"injector is only available after com.hubspot.dropwizard.guice.GuiceBundle.initialize() is called");
        return this.baseInjector.createChildInjector(new Module[]{new JerseyGuiceModule(JerseyGuiceUtils.newServiceLocator())});
    }

    public static class Builder<T extends Configuration> {
        private AutoConfig autoConfig;
        private List<Module> modules = Lists.newArrayList();
        private Optional<Class<T>> configurationClass = Optional.absent();
        private InjectorFactory injectorFactory = new InjectorFactoryImpl();

        public Builder<T> addModule(Module module) {
            Preconditions.checkNotNull((Object)module);
            this.modules.add(module);
            return this;
        }

        public Builder<T> addModules(Module moduleOne, Module moduleTwo, Module ... moreModules) {
            this.addModule(moduleOne);
            this.addModule(moduleTwo);
            for (Module module : moreModules) {
                this.addModule(module);
            }
            return this;
        }

        public Builder<T> setConfigClass(Class<T> clazz) {
            this.configurationClass = Optional.of(clazz);
            return this;
        }

        public Builder<T> setInjectorFactory(InjectorFactory factory) {
            Preconditions.checkNotNull((Object)factory);
            this.injectorFactory = factory;
            return this;
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkArgument((basePackages.length > 0 ? 1 : 0) != 0, (Object)"at least one package must be specified for AutoConfig");
            Preconditions.checkArgument((this.autoConfig == null ? 1 : 0) != 0, (Object)"autoConfig already enabled!");
            this.autoConfig = new AutoConfig(basePackages);
            return this;
        }

        public GuiceBundle<T> build() {
            return this.build(Stage.PRODUCTION);
        }

        public GuiceBundle<T> build(Stage s) {
            return new GuiceBundle(s, this.autoConfig, this.modules, this.configurationClass, this.injectorFactory);
        }
    }
}

