/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Type;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyUtil {
    private static final Logger logger = LoggerFactory.getLogger(JerseyUtil.class);

    public static void registerGuiceBound(Injector injector, JerseyEnvironment environment) {
        while (injector != null) {
            for (Key key : injector.getBindings().keySet()) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) continue;
                Class c = (Class)type;
                if (JerseyUtil.isProviderClass(c)) {
                    logger.info("Registering {} as a provider class", (Object)c.getName());
                    environment.register(c);
                    continue;
                }
                if (!JerseyUtil.isRootResourceClass(c)) continue;
                if (Resource.isAcceptable((Class)c)) {
                    logger.info("Registering {} as a root resource class", (Object)c.getName());
                    environment.register(c);
                    continue;
                }
                logger.warn("Class {} was not registered as a resource. Bind a concrete implementation instead.", (Object)c.getName());
            }
            injector = injector.getParent();
        }
    }

    private static boolean isProviderClass(Class<?> c) {
        return c != null && c.isAnnotationPresent(Provider.class);
    }

    private static boolean isRootResourceClass(Class<?> c) {
        if (c == null) {
            return false;
        }
        if (c.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Class<?> i : c.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return true;
        }
        return false;
    }

    public static void registerGuiceFilter(Environment environment) {
        environment.servlets().addFilter("Guice Filter", GuiceFilter.class).addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }
}

