/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guicier;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.hubspot.dropwizard.guicier.DropwizardAwareModule;
import com.hubspot.dropwizard.guicier.DropwizardGuiceContainer;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final String GUICE_BUNDLE_NAME = "_guice_bundle";
    private static final Named GUICE_BUNDLE_NAMED = Names.named((String)"_guice_bundle");
    private static final Logger LOG = LoggerFactory.getLogger(GuiceBundle.class);
    private final Class<T> configClass;
    private final ImmutableSet<DropwizardAwareModule<T>> dropwizardAwareModules;
    private final ImmutableSet<Module> guiceModules;
    private final Stage guiceStage;
    private Bootstrap<?> bootstrap = null;
    @Inject
    @Named(value="_guice_bundle")
    private volatile Function<ResourceConfig, ServletContainer> replacer = null;

    public static <U extends Configuration> Builder<U> defaultBuilder(Class<U> configClass) {
        return new Builder(configClass);
    }

    private GuiceBundle(Class<T> configClass, ImmutableSet<Module> guiceModules, ImmutableSet<DropwizardAwareModule<T>> dropwizardAwareModules, Stage guiceStage) {
        this.configClass = configClass;
        this.guiceModules = guiceModules;
        this.dropwizardAwareModules = dropwizardAwareModules;
        this.guiceStage = guiceStage;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void run(T configuration, final Environment environment) throws Exception {
        for (DropwizardAwareModule dropwizardAwareModule : this.dropwizardAwareModules) {
            dropwizardAwareModule.setBootstrap(this.bootstrap);
            dropwizardAwareModule.setConfiguration(configuration);
            dropwizardAwareModule.setEnvironment(environment);
        }
        DropwizardModule dropwizardModule = new DropwizardModule();
        Injector injector = Guice.createInjector((Stage)this.guiceStage, (Iterable)ImmutableSet.builder().addAll(this.guiceModules).addAll(this.dropwizardAwareModules).add((Object)new GuiceEnforcerModule()).add((Object)new JerseyServletModule()).add((Object)dropwizardModule).add((Object)new Module((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void configure(Binder binder) {
                binder.bind(Environment.class).toInstance((Object)environment);
                binder.bind(GuiceBundle.this.configClass).toInstance((Object)this.val$configuration);
                binder.bind(GuiceContainer.class).to(DropwizardGuiceContainer.class).in(Scopes.SINGLETON);
                binder.bind((TypeLiteral)new TypeLiteral<Function<ResourceConfig, ServletContainer>>(){}).annotatedWith((Annotation)GUICE_BUNDLE_NAMED).to(GuiceContainerReplacer.class).in(Scopes.SINGLETON);
            }
        }).build());
        injector.injectMembers((Object)this);
        Preconditions.checkState((this.replacer != null ? 1 : 0) != 0, (Object)"No guice container replacer was injected!");
        for (Managed managed : dropwizardModule.getManaged()) {
            LOG.info("Added guice injected managed Object: {}", (Object)managed.getClass().getName());
            environment.lifecycle().manage(managed);
        }
        for (Task task : dropwizardModule.getTasks()) {
            environment.admin().addTask(task);
            LOG.info("Added guice injected Task: {}", (Object)task.getClass().getName());
        }
        for (HealthCheck healthcheck : dropwizardModule.getHealthChecks()) {
            environment.healthChecks().register(healthcheck.getClass().getSimpleName(), healthcheck);
            LOG.info("Added guice injected health check: {}", (Object)healthcheck.getClass().getName());
        }
        for (ServerLifecycleListener serverLifecycleListener : dropwizardModule.getServerLifecycleListeners()) {
            environment.lifecycle().addServerLifecycleListener(serverLifecycleListener);
        }
        GuiceBundle.addJerseyBindings(environment, injector, "com.sun.jersey.spi.container.ContainerRequestFilters", ContainerRequestFilter.class);
        GuiceBundle.addJerseyBindings(environment, injector, "com.sun.jersey.spi.container.ContainerResponseFilters", ContainerResponseFilter.class);
        GuiceBundle.addJerseyBindings(environment, injector, "com.sun.jersey.spi.container.ResourceFilters", ResourceFilterFactory.class);
        environment.jersey().replace(this.replacer);
        environment.servlets().addFilter("Guice Filter", GuiceFilter.class).addMappingForUrlPatterns(null, false, new String[]{environment.getApplicationContext().getContextPath() + "*"});
    }

    private static <T> void addJerseyBindings(Environment environment, Injector injector, String propertyName, Class<T> clazz) {
        TypeToken setToken = new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, clazz);
        Key key = Key.get((Type)setToken.getType());
        Binding binding = injector.getExistingBinding(key);
        if (binding != null) {
            Set values = (Set)injector.getInstance(key);
            environment.jersey().property(propertyName, (Object)ImmutableList.copyOf((Collection)values));
        }
    }

    public static class Builder<U extends Configuration> {
        private final Class<U> configClass;
        private final ImmutableSet.Builder<Module> guiceModules = ImmutableSet.builder();
        private final ImmutableSet.Builder<DropwizardAwareModule<U>> dropwizardAwareModules = ImmutableSet.builder();
        private Stage guiceStage = Stage.PRODUCTION;

        private Builder(Class<U> configClass) {
            this.configClass = configClass;
        }

        public final Builder<U> stage(Stage guiceStage) {
            Preconditions.checkNotNull((Object)guiceStage, (Object)"guiceStage is null");
            if (guiceStage != Stage.PRODUCTION) {
                LOG.warn("Guice should only ever run in PRODUCTION mode except for testing!");
            }
            this.guiceStage = guiceStage;
            return this;
        }

        public final Builder<U> modules(Module ... modules) {
            return this.modules(Arrays.asList(modules));
        }

        public final Builder<U> modules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                if (module instanceof DropwizardAwareModule) {
                    this.dropwizardAwareModules.add((Object)((DropwizardAwareModule)module));
                    continue;
                }
                this.guiceModules.add((Object)module);
            }
            return this;
        }

        public final GuiceBundle<U> build() {
            return new GuiceBundle(this.configClass, this.guiceModules.build(), this.dropwizardAwareModules.build(), this.guiceStage);
        }
    }

    public static class DropwizardModule
    implements Module {
        private final ImmutableSet.Builder<Managed> managedBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<Task> taskBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<HealthCheck> healthcheckBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<ServerLifecycleListener> serverLifecycleListenerBuilder = ImmutableSet.builder();

        public void configure(Binder binder) {
            binder.bindListener(Matchers.any(), new TypeListener(){

                public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
                    encounter.register(new InjectionListener<T>(){

                        public void afterInjection(T obj) {
                            if (obj instanceof Managed) {
                                DropwizardModule.this.managedBuilder.add((Object)((Managed)obj));
                            }
                            if (obj instanceof Task) {
                                DropwizardModule.this.taskBuilder.add((Object)((Task)obj));
                            }
                            if (obj instanceof HealthCheck) {
                                DropwizardModule.this.healthcheckBuilder.add((Object)((HealthCheck)obj));
                            }
                            if (obj instanceof ServerLifecycleListener) {
                                DropwizardModule.this.serverLifecycleListenerBuilder.add((Object)((ServerLifecycleListener)obj));
                            }
                        }
                    });
                }
            });
        }

        public Set<Managed> getManaged() {
            return this.managedBuilder.build();
        }

        public Set<Task> getTasks() {
            return this.taskBuilder.build();
        }

        public Set<HealthCheck> getHealthChecks() {
            return this.healthcheckBuilder.build();
        }

        public Set<ServerLifecycleListener> getServerLifecycleListeners() {
            return this.serverLifecycleListenerBuilder.build();
        }
    }

    public static class GuiceEnforcerModule
    implements Module {
        public void configure(Binder binder) {
            binder.disableCircularProxies();
            binder.requireExplicitBindings();
            binder.requireExactBindingAnnotations();
            binder.requireAtInjectOnConstructors();
        }
    }

    private static class GuiceContainerReplacer
    implements Function<ResourceConfig, ServletContainer> {
        private final GuiceContainer container;

        @Inject
        GuiceContainerReplacer(GuiceContainer container) {
            this.container = (GuiceContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        }

        public ServletContainer apply(@Nonnull ResourceConfig resourceConfig) {
            return this.container;
        }
    }
}

