/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guicier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.hubspot.dropwizard.guicier.AllowUnknownFieldsObjectMapper;
import com.hubspot.dropwizard.guicier.DropwizardAwareModule;
import com.hubspot.dropwizard.guicier.DropwizardModule;
import com.squarespace.jersey2.guice.JerseyGuiceModule;
import com.squarespace.jersey2.guice.JerseyGuiceUtils;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.EventListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceBundle.class);
    private final Class<T> configClass;
    private final ImmutableSet<DropwizardAwareModule<T>> dropwizardAwareModules;
    private final ImmutableSet<Module> guiceModules;
    private final Stage guiceStage;
    private final boolean allowUnknownFields;
    private final boolean enableGuiceEnforcer;
    private Bootstrap<?> bootstrap = null;
    private Injector injector = null;

    public static <U extends Configuration> Builder<U> defaultBuilder(Class<U> configClass) {
        return new Builder(configClass);
    }

    private GuiceBundle(Class<T> configClass, ImmutableSet<Module> guiceModules, ImmutableSet<DropwizardAwareModule<T>> dropwizardAwareModules, Stage guiceStage, boolean allowUnknownFields, boolean enableGuiceEnforcer) {
        this.configClass = configClass;
        this.guiceModules = guiceModules;
        this.dropwizardAwareModules = dropwizardAwareModules;
        this.guiceStage = guiceStage;
        this.allowUnknownFields = allowUnknownFields;
        this.enableGuiceEnforcer = enableGuiceEnforcer;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.bootstrap = bootstrap;
        if (this.allowUnknownFields) {
            AllowUnknownFieldsObjectMapper.applyTo(bootstrap);
        }
    }

    public void run(T configuration, final Environment environment) throws Exception {
        for (DropwizardAwareModule dropwizardAwareModule : this.dropwizardAwareModules) {
            dropwizardAwareModule.setBootstrap(this.bootstrap);
            dropwizardAwareModule.setConfiguration(configuration);
            dropwizardAwareModule.setEnvironment(environment);
        }
        DropwizardModule dropwizardModule = new DropwizardModule(environment);
        ImmutableSet.Builder modulesBuilder = ImmutableSet.builder().addAll(this.guiceModules).addAll(this.dropwizardAwareModules).add((Object)new ServletModule()).add((Object)dropwizardModule).add((Object)new Module((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void configure(Binder binder) {
                binder.bind(Environment.class).toInstance((Object)environment);
                binder.bind(GuiceBundle.this.configClass).toInstance((Object)this.val$configuration);
            }
        });
        if (this.enableGuiceEnforcer) {
            modulesBuilder.add((Object)new GuiceEnforcerModule());
        }
        this.injector = Guice.createInjector((Stage)this.guiceStage, (Iterable)modulesBuilder.build());
        JerseyGuiceUtils.install((ServiceLocatorGenerator)new ServiceLocatorGenerator(){

            public ServiceLocator create(String name, ServiceLocator parent) {
                if (!name.startsWith("__HK2_Generated_")) {
                    return null;
                }
                return (ServiceLocator)GuiceBundle.this.injector.createChildInjector(new Module[]{new JerseyGuiceModule(name)}).getInstance(ServiceLocator.class);
            }
        });
        dropwizardModule.register(this.injector);
        environment.servlets().addFilter("Guice Filter", GuiceFilter.class).addMappingForUrlPatterns(null, false, new String[]{"/*"});
        environment.servlets().addServletListeners(new EventListener[]{new GuiceServletContextListener(){

            protected Injector getInjector() {
                return GuiceBundle.this.injector;
            }
        }});
    }

    public Injector getInjector() {
        return (Injector)Preconditions.checkNotNull((Object)this.injector, (Object)"injector has not been initialized yet");
    }

    public static class Builder<U extends Configuration> {
        private final Class<U> configClass;
        private final ImmutableSet.Builder<Module> guiceModules = ImmutableSet.builder();
        private final ImmutableSet.Builder<DropwizardAwareModule<U>> dropwizardAwareModules = ImmutableSet.builder();
        private Stage guiceStage = Stage.PRODUCTION;
        private boolean allowUnknownFields = true;
        private boolean enableGuiceEnforcer = true;

        private Builder(Class<U> configClass) {
            this.configClass = configClass;
        }

        public final Builder<U> stage(Stage guiceStage) {
            Preconditions.checkNotNull((Object)guiceStage, (Object)"guiceStage is null");
            if (guiceStage != Stage.PRODUCTION) {
                LOG.warn("Guice should only ever run in PRODUCTION mode except for testing!");
            }
            this.guiceStage = guiceStage;
            return this;
        }

        public final Builder<U> allowUnknownFields(boolean allowUnknownFields) {
            this.allowUnknownFields = allowUnknownFields;
            return this;
        }

        public final Builder<U> enableGuiceEnforcer(boolean enableGuiceEnforcer) {
            this.enableGuiceEnforcer = enableGuiceEnforcer;
            return this;
        }

        public final Builder<U> modules(Module ... modules) {
            return this.modules(Arrays.asList(modules));
        }

        public final Builder<U> modules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                if (module instanceof DropwizardAwareModule) {
                    this.dropwizardAwareModules.add((Object)((DropwizardAwareModule)module));
                    continue;
                }
                this.guiceModules.add((Object)module);
            }
            return this;
        }

        public final GuiceBundle<U> build() {
            return new GuiceBundle(this.configClass, this.guiceModules.build(), this.dropwizardAwareModules.build(), this.guiceStage, this.allowUnknownFields, this.enableGuiceEnforcer);
        }
    }

    public static class GuiceEnforcerModule
    implements Module {
        public void configure(Binder binder) {
            binder.disableCircularProxies();
            binder.requireExplicitBindings();
            binder.requireExactBindingAnnotations();
            binder.requireAtInjectOnConstructors();
        }
    }
}

