/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guicier;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.setup.Bootstrap;

public class AllowUnknownFieldsObjectMapper
extends ObjectMapper {
    private AllowUnknownFieldsObjectMapper(ObjectMapper source) {
        super(source);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static void applyTo(Bootstrap<?> bootstrap) {
        bootstrap.setObjectMapper((ObjectMapper)new AllowUnknownFieldsObjectMapper(bootstrap.getObjectMapper()));
    }

    public ObjectMapper copy() {
        return new AllowUnknownFieldsObjectMapper(this);
    }

    public ObjectMapper configure(DeserializationFeature f, boolean state) {
        if (f != DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES) {
            return super.configure(f, state);
        }
        return this;
    }

    public ObjectMapper enable(DeserializationFeature feature) {
        if (feature != DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES) {
            return super.enable(feature);
        }
        return this;
    }

    public ObjectMapper enable(DeserializationFeature first, DeserializationFeature ... f) {
        if (first != DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES) {
            super.enable(first);
        }
        for (DeserializationFeature feature : f) {
            if (feature == DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES) continue;
            super.enable(feature);
        }
        return this;
    }
}

